/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUOrigin2DDict.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUOrigin2DDict convertDictionary<GPUOrigin2DDict>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUOrigin2DDict result;
    JSValue xValue;
    if (isNullOrUndefined)
        xValue = jsUndefined();
    else {
        xValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "x"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!xValue.isUndefined()) {
        result.x = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, xValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.x = 0;
    JSValue yValue;
    if (isNullOrUndefined)
        yValue = jsUndefined();
    else {
        yValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "y"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!yValue.isUndefined()) {
        result.y = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, yValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.y = 0;
    return result;
}

} // namespace WebCore
