/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FULLSCREEN_API)

#include "JSFullscreenOptions.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(FULLSCREEN_API)

template<> FullscreenOptions convertDictionary<FullscreenOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FullscreenOptions result;
    JSValue navigationUIValue;
    if (isNullOrUndefined)
        navigationUIValue = jsUndefined();
    else {
        navigationUIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "navigationUI"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!navigationUIValue.isUndefined()) {
        result.navigationUI = convert<IDLEnumeration<FullscreenOptions::NavigationUI>>(lexicalGlobalObject, navigationUIValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.navigationUI = FullscreenOptions::NavigationUI::Auto;
    return result;
}

#endif

#if ENABLE(FULLSCREEN_API)

String convertEnumerationToString(FullscreenOptions::NavigationUI enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("auto"),
        MAKE_STATIC_STRING_IMPL("show"),
        MAKE_STATIC_STRING_IMPL("hide"),
    };
    static_assert(static_cast<size_t>(FullscreenOptions::NavigationUI::Auto) == 0, "FullscreenOptions::NavigationUI::Auto is not 0 as expected");
    static_assert(static_cast<size_t>(FullscreenOptions::NavigationUI::Show) == 1, "FullscreenOptions::NavigationUI::Show is not 1 as expected");
    static_assert(static_cast<size_t>(FullscreenOptions::NavigationUI::Hide) == 2, "FullscreenOptions::NavigationUI::Hide is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FullscreenOptions::NavigationUI enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FullscreenOptions::NavigationUI> parseEnumerationFromString<FullscreenOptions::NavigationUI>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, FullscreenOptions::NavigationUI> mappings[] = {
        { "auto", FullscreenOptions::NavigationUI::Auto },
        { "hide", FullscreenOptions::NavigationUI::Hide },
        { "show", FullscreenOptions::NavigationUI::Show },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FullscreenOptions::NavigationUI> parseEnumeration<FullscreenOptions::NavigationUI>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FullscreenOptions::NavigationUI>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<FullscreenOptions::NavigationUI>()
{
    return "\"auto\", \"show\", \"hide\"";
}

#endif

} // namespace WebCore

#endif // ENABLE(FULLSCREEN_API)
