/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEndingType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(EndingType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("transparent"),
        MAKE_STATIC_STRING_IMPL("native"),
    };
    static_assert(static_cast<size_t>(EndingType::Transparent) == 0, "EndingType::Transparent is not 0 as expected");
    static_assert(static_cast<size_t>(EndingType::Native) == 1, "EndingType::Native is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, EndingType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<EndingType> parseEnumerationFromString<EndingType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, EndingType> mappings[] = {
        { "native", EndingType::Native },
        { "transparent", EndingType::Transparent },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<EndingType> parseEnumeration<EndingType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<EndingType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<EndingType>()
{
    return "\"transparent\", \"native\"";
}

} // namespace WebCore
