/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDecompressionStreamDecoder.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDecompressionStreamDecoderPrototypeFunction_decode);
static JSC_DECLARE_HOST_FUNCTION(jsDecompressionStreamDecoderPrototypeFunction_flush);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDecompressionStreamDecoderConstructor);

class JSDecompressionStreamDecoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDecompressionStreamDecoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDecompressionStreamDecoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSDecompressionStreamDecoderPrototype>(vm)) JSDecompressionStreamDecoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDecompressionStreamDecoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDecompressionStreamDecoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDecompressionStreamDecoderPrototype, JSDecompressionStreamDecoderPrototype::Base);

using JSDecompressionStreamDecoderDOMConstructor = JSDOMConstructor<JSDecompressionStreamDecoder>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDecompressionStreamDecoderDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDecompressionStreamDecoderDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto format = convert<IDLByte>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DecompressionStreamDecoder::create(WTFMove(format));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DecompressionStreamDecoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DecompressionStreamDecoder>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDecompressionStreamDecoderDOMConstructorConstruct, JSDecompressionStreamDecoderDOMConstructor::construct);

template<> const ClassInfo JSDecompressionStreamDecoderDOMConstructor::s_info = { "DecompressionStreamDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDecompressionStreamDecoderDOMConstructor) };

template<> JSValue JSDecompressionStreamDecoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDecompressionStreamDecoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DecompressionStreamDecoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDecompressionStreamDecoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDecompressionStreamDecoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDecompressionStreamDecoderConstructor, 0 } },
};

const ClassInfo JSDecompressionStreamDecoderPrototype::s_info = { "DecompressionStreamDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDecompressionStreamDecoderPrototype) };

void JSDecompressionStreamDecoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDecompressionStreamDecoder::info(), JSDecompressionStreamDecoderPrototypeTableValues, *this);
    putDirect(vm, builtinNames(vm).decodePrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsDecompressionStreamDecoderPrototypeFunction_decode, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, builtinNames(vm).flushPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsDecompressionStreamDecoderPrototypeFunction_flush, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDecompressionStreamDecoder::s_info = { "DecompressionStreamDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDecompressionStreamDecoder) };

JSDecompressionStreamDecoder::JSDecompressionStreamDecoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DecompressionStreamDecoder>&& impl)
    : JSDOMWrapper<DecompressionStreamDecoder>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DecompressionStreamDecoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDecompressionStreamDecoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDecompressionStreamDecoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDecompressionStreamDecoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDecompressionStreamDecoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDecompressionStreamDecoder>(vm, globalObject);
}

JSValue JSDecompressionStreamDecoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDecompressionStreamDecoderDOMConstructor, DOMConstructorID::DecompressionStreamDecoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDecompressionStreamDecoder::destroy(JSC::JSCell* cell)
{
    JSDecompressionStreamDecoder* thisObject = static_cast<JSDecompressionStreamDecoder*>(cell);
    thisObject->JSDecompressionStreamDecoder::~JSDecompressionStreamDecoder();
}

JSC_DEFINE_CUSTOM_GETTER(jsDecompressionStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDecompressionStreamDecoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDecompressionStreamDecoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsDecompressionStreamDecoderPrototypeFunction_decodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDecompressionStreamDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto chunk = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUint8Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.decode(WTFMove(chunk)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDecompressionStreamDecoderPrototypeFunction_decode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDecompressionStreamDecoder>::call<jsDecompressionStreamDecoderPrototypeFunction_decodeBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "decode");
}

static inline JSC::EncodedJSValue jsDecompressionStreamDecoderPrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDecompressionStreamDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUint8Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.flush())));
}

JSC_DEFINE_HOST_FUNCTION(jsDecompressionStreamDecoderPrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDecompressionStreamDecoder>::call<jsDecompressionStreamDecoderPrototypeFunction_flushBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "flush");
}

JSC::GCClient::IsoSubspace* JSDecompressionStreamDecoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDecompressionStreamDecoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDecompressionStreamDecoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDecompressionStreamDecoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDecompressionStreamDecoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDecompressionStreamDecoder = std::forward<decltype(space)>(space); }
    );
}

void JSDecompressionStreamDecoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDecompressionStreamDecoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDecompressionStreamDecoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDecompressionStreamDecoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDecompressionStreamDecoder = static_cast<JSDecompressionStreamDecoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDecompressionStreamDecoder->wrapped(), jsDecompressionStreamDecoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DecompressionStreamDecoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26DecompressionStreamDecoderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DecompressionStreamDecoder>&& impl)
{

    if constexpr (std::is_polymorphic_v<DecompressionStreamDecoder>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DecompressionStreamDecoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26DecompressionStreamDecoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DecompressionStreamDecoder has subclasses. If DecompressionStreamDecoder has subclasses that get passed
        // to toJS() we currently require DecompressionStreamDecoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<DecompressionStreamDecoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DecompressionStreamDecoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DecompressionStreamDecoder* JSDecompressionStreamDecoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDecompressionStreamDecoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
