/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSComputedEffectTiming.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include "JSFillMode.h"
#include "JSPlaybackDirection.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ComputedEffectTiming convertDictionary<ComputedEffectTiming>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ComputedEffectTiming result;
    JSValue delayValue;
    if (isNullOrUndefined)
        delayValue = jsUndefined();
    else {
        delayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delay"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!delayValue.isUndefined()) {
        result.delay = convert<IDLDouble>(lexicalGlobalObject, delayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.delay = 0;
    JSValue directionValue;
    if (isNullOrUndefined)
        directionValue = jsUndefined();
    else {
        directionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "direction"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!directionValue.isUndefined()) {
        result.direction = convert<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, directionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.direction = PlaybackDirection::Normal;
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.duration = "auto"_s;
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = "linear"_s;
    JSValue endDelayValue;
    if (isNullOrUndefined)
        endDelayValue = jsUndefined();
    else {
        endDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endDelay"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endDelayValue.isUndefined()) {
        result.endDelay = convert<IDLDouble>(lexicalGlobalObject, endDelayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.endDelay = 0;
    JSValue fillValue;
    if (isNullOrUndefined)
        fillValue = jsUndefined();
    else {
        fillValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fill"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fillValue.isUndefined()) {
        result.fill = convert<IDLEnumeration<FillMode>>(lexicalGlobalObject, fillValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.fill = FillMode::Auto;
    JSValue iterationStartValue;
    if (isNullOrUndefined)
        iterationStartValue = jsUndefined();
    else {
        iterationStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterationStart"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iterationStartValue.isUndefined()) {
        result.iterationStart = convert<IDLDouble>(lexicalGlobalObject, iterationStartValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.iterationStart = 0.0;
    JSValue iterationsValue;
    if (isNullOrUndefined)
        iterationsValue = jsUndefined();
    else {
        iterationsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterations"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iterationsValue.isUndefined()) {
        result.iterations = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, iterationsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.iterations = 1.0;
    JSValue activeDurationValue;
    if (isNullOrUndefined)
        activeDurationValue = jsUndefined();
    else {
        activeDurationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "activeDuration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!activeDurationValue.isUndefined()) {
        result.activeDuration = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, activeDurationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue currentIterationValue;
    if (isNullOrUndefined)
        currentIterationValue = jsUndefined();
    else {
        currentIterationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "currentIteration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!currentIterationValue.isUndefined()) {
        result.currentIteration = convert<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, currentIterationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.currentIteration = std::nullopt;
    JSValue endTimeValue;
    if (isNullOrUndefined)
        endTimeValue = jsUndefined();
    else {
        endTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endTimeValue.isUndefined()) {
        result.endTime = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, endTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue localTimeValue;
    if (isNullOrUndefined)
        localTimeValue = jsUndefined();
    else {
        localTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "localTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!localTimeValue.isUndefined()) {
        result.localTime = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, localTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.localTime = std::nullopt;
    JSValue progressValue;
    if (isNullOrUndefined)
        progressValue = jsUndefined();
    else {
        progressValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "progress"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!progressValue.isUndefined()) {
        result.progress = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, progressValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.progress = std::nullopt;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ComputedEffectTiming& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto delayValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.delay);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "delay"_s), delayValue);
    auto directionValue = toJS<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, throwScope, dictionary.direction);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "direction"_s), directionValue);
    auto durationValue = toJS<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, dictionary.duration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "duration"_s), durationValue);
    auto easingValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.easing);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "easing"_s), easingValue);
    auto endDelayValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.endDelay);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "endDelay"_s), endDelayValue);
    auto fillValue = toJS<IDLEnumeration<FillMode>>(lexicalGlobalObject, throwScope, dictionary.fill);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "fill"_s), fillValue);
    auto iterationStartValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.iterationStart);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iterationStart"_s), iterationStartValue);
    auto iterationsValue = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, dictionary.iterations);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iterations"_s), iterationsValue);
    if (!IDLUnrestrictedDouble::isNullValue(dictionary.activeDuration)) {
        auto activeDurationValue = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, IDLUnrestrictedDouble::extractValueFromNullable(dictionary.activeDuration));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "activeDuration"_s), activeDurationValue);
    }
    auto currentIterationValue = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, dictionary.currentIteration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "currentIteration"_s), currentIterationValue);
    if (!IDLUnrestrictedDouble::isNullValue(dictionary.endTime)) {
        auto endTimeValue = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, IDLUnrestrictedDouble::extractValueFromNullable(dictionary.endTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "endTime"_s), endTimeValue);
    }
    auto localTimeValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, dictionary.localTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "localTime"_s), localTimeValue);
    auto progressValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, dictionary.progress);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "progress"_s), progressValue);
    return result;
}

} // namespace WebCore
