/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSOMVariableReferenceValue.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSUnparsedValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMVariableReferenceValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMVariableReferenceValue_variable);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOMVariableReferenceValue_variable);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMVariableReferenceValue_fallback);

class JSCSSOMVariableReferenceValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSOMVariableReferenceValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSOMVariableReferenceValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSOMVariableReferenceValuePrototype>(vm)) JSCSSOMVariableReferenceValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOMVariableReferenceValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSOMVariableReferenceValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOMVariableReferenceValuePrototype, JSCSSOMVariableReferenceValuePrototype::Base);

using JSCSSOMVariableReferenceValueDOMConstructor = JSDOMConstructor<JSCSSOMVariableReferenceValue>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSOMVariableReferenceValueDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSOMVariableReferenceValueDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto variable = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto fallback = convert<IDLNullable<IDLInterface<CSSUnparsedValue>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "fallback", "CSSVariableReferenceValue", nullptr, "CSSUnparsedValue"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = CSSOMVariableReferenceValue::create(WTFMove(variable), WTFMove(fallback));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSOMVariableReferenceValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSOMVariableReferenceValue>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSOMVariableReferenceValueDOMConstructorConstruct, JSCSSOMVariableReferenceValueDOMConstructor::construct);

template<> const ClassInfo JSCSSOMVariableReferenceValueDOMConstructor::s_info = { "CSSVariableReferenceValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMVariableReferenceValueDOMConstructor) };

template<> JSValue JSCSSOMVariableReferenceValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSOMVariableReferenceValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSVariableReferenceValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSOMVariableReferenceValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSOMVariableReferenceValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMVariableReferenceValueConstructor, 0 } },
    { "variable"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMVariableReferenceValue_variable, setJSCSSOMVariableReferenceValue_variable } },
    { "fallback"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMVariableReferenceValue_fallback, 0 } },
};

const ClassInfo JSCSSOMVariableReferenceValuePrototype::s_info = { "CSSVariableReferenceValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMVariableReferenceValuePrototype) };

void JSCSSOMVariableReferenceValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSOMVariableReferenceValue::info(), JSCSSOMVariableReferenceValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSOMVariableReferenceValue::s_info = { "CSSVariableReferenceValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMVariableReferenceValue) };

JSCSSOMVariableReferenceValue::JSCSSOMVariableReferenceValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSOMVariableReferenceValue>&& impl)
    : JSDOMWrapper<CSSOMVariableReferenceValue>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSOMVariableReferenceValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSOMVariableReferenceValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSOMVariableReferenceValuePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCSSOMVariableReferenceValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSOMVariableReferenceValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSOMVariableReferenceValue>(vm, globalObject);
}

JSValue JSCSSOMVariableReferenceValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSOMVariableReferenceValueDOMConstructor, DOMConstructorID::CSSOMVariableReferenceValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCSSOMVariableReferenceValue::destroy(JSC::JSCell* cell)
{
    JSCSSOMVariableReferenceValue* thisObject = static_cast<JSCSSOMVariableReferenceValue*>(cell);
    thisObject->JSCSSOMVariableReferenceValue::~JSCSSOMVariableReferenceValue();
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMVariableReferenceValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSOMVariableReferenceValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSOMVariableReferenceValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCSSOMVariableReferenceValue_variableGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMVariableReferenceValue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.variable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMVariableReferenceValue_variable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMVariableReferenceValue>::get<jsCSSOMVariableReferenceValue_variableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOMVariableReferenceValue_variableSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMVariableReferenceValue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setVariable(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOMVariableReferenceValue_variable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMVariableReferenceValue>::set<setJSCSSOMVariableReferenceValue_variableSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOMVariableReferenceValue_fallbackGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMVariableReferenceValue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<CSSUnparsedValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fallback())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMVariableReferenceValue_fallback, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMVariableReferenceValue>::get<jsCSSOMVariableReferenceValue_fallbackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSOMVariableReferenceValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSOMVariableReferenceValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSOMVariableReferenceValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSOMVariableReferenceValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSOMVariableReferenceValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSOMVariableReferenceValue = std::forward<decltype(space)>(space); }
    );
}

void JSCSSOMVariableReferenceValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSOMVariableReferenceValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCSSOMVariableReferenceValueOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCSSOMVariableReferenceValueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSOMVariableReferenceValue = static_cast<JSCSSOMVariableReferenceValue*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCSSOMVariableReferenceValue->wrapped(), jsCSSOMVariableReferenceValue);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSOMVariableReferenceValue@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27CSSOMVariableReferenceValueE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSOMVariableReferenceValue>&& impl)
{

    if constexpr (std::is_polymorphic_v<CSSOMVariableReferenceValue>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSOMVariableReferenceValue@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27CSSOMVariableReferenceValueE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSOMVariableReferenceValue has subclasses. If CSSOMVariableReferenceValue has subclasses that get passed
        // to toJS() we currently require CSSOMVariableReferenceValue you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CSSOMVariableReferenceValue>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSOMVariableReferenceValue& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSOMVariableReferenceValue* JSCSSOMVariableReferenceValue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSOMVariableReferenceValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
