/*
 * Copyright (c) 2016, 2022 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "CompressionStreamBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_compressionStreamInitializeCompressionStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_compressionStreamInitializeCompressionStreamCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_compressionStreamInitializeCompressionStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const int s_compressionStreamInitializeCompressionStreamCodeLength = 2531;
static const JSC::Intrinsic s_compressionStreamInitializeCompressionStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_compressionStreamInitializeCompressionStreamCode =
    "(function (format)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const errorMessage = \"CompressionStream requires a single argument with the value 'deflate', 'deflate-raw', or 'gzip'.\";\n" \
    "\n" \
    "    if (arguments.length < 1)\n" \
    "        @throwTypeError(errorMessage);\n" \
    "\n" \
    "    const algorithms = ['gzip', 'deflate', 'deflate-raw'];\n" \
    "    const lowercaseFormat = @toString(arguments[0]).toLowerCase();\n" \
    "    const findAlgorithm = (element) => element === lowercaseFormat;\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    const index = algorithms.findIndex(findAlgorithm);\n" \
    "\n" \
    "    if (index === -1)\n" \
    "        @throwTypeError(errorMessage);\n" \
    "\n" \
    "    //\n" \
    "    const startAlgorithm = () => {\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const transformAlgorithm = (chunk) => {\n" \
    "        if (!@isObject(chunk) || (!(chunk instanceof @ArrayBuffer) && !(chunk.buffer instanceof @ArrayBuffer)))\n" \
    "            return @Promise.@reject(@makeTypeError(\"Invalid type should be ArrayBuffer\"));\n" \
    "\n" \
    "        try {\n" \
    "            const encoder = @getByIdDirectPrivate(this, \"CompressionStreamEncoder\");\n" \
    "\n" \
    "            let buffer = encoder.@encode(chunk);\n" \
    "            if (buffer) {\n" \
    "                const transformStream = @getByIdDirectPrivate(this, \"CompressionStreamTransform\");\n" \
    "                const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "                @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "            }\n" \
    "        } catch (e) {\n" \
    "            return @Promise.@reject(@makeTypeError(e.message));\n" \
    "        }\n" \
    "\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const flushAlgorithm = () => {\n" \
    "        const encoder = @getByIdDirectPrivate(this, \"CompressionStreamEncoder\");\n" \
    "\n" \
    "        let buffer;\n" \
    "        try {\n" \
    "            buffer = encoder.@flush();\n" \
    "        } catch (e) {\n" \
    "            return @Promise.@reject(@makeTypeError(e.message));\n" \
    "        }\n" \
    "        if (buffer) {\n" \
    "            const transformStream = @getByIdDirectPrivate(this, \"CompressionStreamTransform\");\n" \
    "            const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "            @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "        }\n" \
    "\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "\n" \
    "    const [transform, readable, writable] = @createTransformStream(startAlgorithm, transformAlgorithm, flushAlgorithm);\n" \
    "    @putByIdDirectPrivate(this, \"CompressionStreamTransform\", transform);\n" \
    "    @putByIdDirectPrivate(this, \"readable\", readable);\n" \
    "    @putByIdDirectPrivate(this, \"writable\", writable);\n" \
    "    @putByIdDirectPrivate(this, \"CompressionStreamEncoder\", new @CompressionStreamEncoder(index));\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_compressionStreamReadableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_compressionStreamReadableCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_compressionStreamReadableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const int s_compressionStreamReadableCodeLength = 265;
static const JSC::Intrinsic s_compressionStreamReadableCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_compressionStreamReadableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"CompressionStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"CompressionStreamEncoder\", \"readable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"readable\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_compressionStreamWritableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_compressionStreamWritableCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_compressionStreamWritableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const int s_compressionStreamWritableCodeLength = 265;
static const JSC::Intrinsic s_compressionStreamWritableCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_compressionStreamWritableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"CompressionStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"CompressionStreamEncoder\", \"writable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"writable\");\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().compressionStreamBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().compressionStreamBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_COMPRESSIONSTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
