"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const zigbee_herdsman_1 = require("zigbee-herdsman");
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const sunricher = __importStar(require("../lib/sunricher"));
exports.definitions = [
    {
        zigbeeModel: ["S-ZB-PDM1-R251"],
        model: "S-ZB-PDM1-R251",
        vendor: "smarli.",
        description: "Phase dimmer gen 1",
        extend: [m.light({ configureReporting: true }), m.electricityMeter(), sunricher.extend.externalSwitchType(), sunricher.extend.minimumPWM()],
    },
    {
        zigbeeModel: ["S-ZB-1RE1-R251"],
        model: "S-ZB-1RE1-R251",
        vendor: "smarli.",
        description: "Zigbee 2ch smart relay",
        extend: [
            m.identify(),
            m.commandsScenes({ endpointNames: ["1", "2"] }),
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2, "3": 3 } }),
            m.onOff({ powerOnBehavior: false, endpointNames: ["1", "2"], configureReporting: true }),
            m.electricityMeter({ endpointNames: ["3"] }),
        ],
    },
    {
        zigbeeModel: ["S-ZB-COV1-R251"],
        model: "S-ZB-COV1-R251",
        vendor: "smarli.",
        description: "Zigbee curtain control module",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2, "3": 3 } }),
            m.windowCovering({
                controls: ["lift", "tilt"],
                coverInverted: true,
                configureReporting: true,
                endpointNames: ["1"],
            }),
            m.electricityMeter({ endpointNames: ["3"] }),
            m.enumLookup({
                name: "curtain_type",
                cluster: "closuresWindowCovering",
                attribute: { ID: 0x1000, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal: 0,
                    venetian_blind: 1,
                },
                description: "Configure curtain type",
                access: "ALL",
                entityCategory: "config",
            }),
            sunricher.extend.motorControl(),
            m.identify(),
        ],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["closuresWindowCovering"]);
            await reporting.currentPositionLiftPercentage(endpoint);
            await reporting.currentPositionTiltPercentage(endpoint);
        },
    },
];
//# sourceMappingURL=smarli.js.map