/// <reference types="mocha" />
import ts from 'typescript';
import { DocumentManager, Document } from '../../../src/lib/documents';
import { LSConfigManager } from '../../../src/ls-config';
import { LSAndTSDocResolver } from '../../../src/plugins';
export declare function createVirtualTsSystem(currentDirectory: string): ts.System;
export declare function getRandomVirtualDirPath(testDir: string): string;
interface VirtualEnvironmentOptions {
    testDir: string;
    filename: string;
    fileContent: string;
}
export declare function setupVirtualEnvironment({ testDir, fileContent, filename }: VirtualEnvironmentOptions): {
    lsAndTsDocResolver: LSAndTSDocResolver;
    document: Document;
    docManager: DocumentManager;
    virtualSystem: ts.System;
    lsConfigManager: LSConfigManager;
};
export declare function createSnapshotTester<TestOptions extends {
    dir: string;
    workspaceDir: string;
    context: Mocha.Suite;
}>(executeTest: (inputFile: string, testOptions: TestOptions) => Promise<void>): (testOptions: TestOptions) => void;
export declare function updateSnapshotIfFailedOrEmpty({ assertion, expectedFile, rootDir, getFileContent }: {
    assertion: () => void;
    expectedFile: string;
    rootDir: string;
    getFileContent: () => string;
}): void;
export declare function createJsonSnapshotFormatter(dir: string): Promise<(_obj: any) => string>;
export declare function serviceWarmup(suite: Mocha.Suite, testDir: string, rootUri?: string): void;
export declare function recursiveServiceWarmup(suite: Mocha.Suite, testDir: string, rootUri?: string): void;
export {};
