# This file has been autogenerated by the pywayland scanner

# Copyright © 2015-2016 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .zxdg_imported_v2 import ZxdgImportedV2


class ZxdgImporterV2(Interface):
    """Interface for importing surfaces

    A global interface used for importing surfaces exported by xdg_exporter.
    With this interface, a client can create a reference to a surface of
    another client.
    """

    name = "zxdg_importer_v2"
    version = 1


class ZxdgImporterV2Proxy(Proxy[ZxdgImporterV2]):
    interface = ZxdgImporterV2

    @ZxdgImporterV2.request()
    def destroy(self) -> None:
        """Destroy the xdg_importer object

        Notify the compositor that the xdg_importer object will no longer be
        used.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgImporterV2.request(
        Argument(ArgumentType.NewId, interface=ZxdgImportedV2),
        Argument(ArgumentType.String),
    )
    def import_toplevel(self, handle: str) -> Proxy[ZxdgImportedV2]:
        """Import a toplevel surface

        The import_toplevel request imports a surface from any client given a
        handle retrieved by exporting said surface using
        xdg_exporter.export_toplevel. When called, a new xdg_imported object
        will be created. This new object represents the imported surface, and
        the importing client can manipulate its relationship using it. See
        xdg_imported for details.

        :param handle:
            the exported surface handle
        :type handle:
            `ArgumentType.String`
        :returns:
            :class:`~pywayland.protocol.xdg_foreign_unstable_v2.ZxdgImportedV2`
            -- the new xdg_imported object
        """
        id = self._marshal_constructor(1, ZxdgImportedV2, handle)
        return id


class ZxdgImporterV2Resource(Resource):
    interface = ZxdgImporterV2


class ZxdgImporterV2Global(Global):
    interface = ZxdgImporterV2


ZxdgImporterV2._gen_c()
ZxdgImporterV2.proxy_class = ZxdgImporterV2Proxy
ZxdgImporterV2.resource_class = ZxdgImporterV2Resource
ZxdgImporterV2.global_class = ZxdgImporterV2Global
