/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PropertyKeysSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    PropertyKeysSafeDeleteProcessor() {
    }

    @NotNull
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (allElementsToDelete == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        Set<PsiElement> set = Collections.singleton(element);
        if (set == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean handlesElement(PsiElement element) {
        return element instanceof IProperty;
    }

    @NotNull
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> result) {
        if (element == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        if (result == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        if (allElementsToDelete == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result, (PsiElement[])allElementsToDelete);
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        IProperty property;
        String key;
        if (element == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        if (allElementsToDelete == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if ((key = (property = (IProperty)element).getKey()) == null) {
            return null;
        }
        PropertiesFile file = property.getPropertiesFile();
        if (file == null) {
            return null;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PropertiesFile propertiesFile : file.getResourceBundle().getPropertiesFiles()) {
            for (IProperty p : propertiesFile.findPropertiesByKey(key)) {
                PsiElement propertyElement = p.getPsiElement();
                if (allElementsToDelete.contains(propertyElement)) continue;
                result.add(propertyElement);
            }
        }
        return result;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        if (element == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        if (allElementsToDelete == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        return null;
    }

    public UsageInfo @Nullable [] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        if (usages == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(11);
        }
        return usages;
    }

    public void prepareForDeletion(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PropertyKeysSafeDeleteProcessor.$$$reportNull$$$0(12);
        }
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/refactoring/PropertyKeysSafeDeleteProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/refactoring/PropertyKeysSafeDeleteProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSearch";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareForDeletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

