/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.util.Date;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.tika.parser.microsoft.ooxml.ParagraphProperties;
import org.apache.tika.parser.microsoft.ooxml.RunProperties;
import org.apache.tika.utils.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OOXMLWordAndPowerPointTextHandler
extends DefaultHandler {
    public static final String W_NS = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";
    private static final String R = "r";
    private static final String FLD = "fld";
    private static final String RPR = "rPr";
    private static final String P = "p";
    private static final String P_STYLE = "pStyle";
    private static final String PPR = "pPr";
    private static final String T = "t";
    private static final String TAB = "tab";
    private static final String B = "b";
    private static final String ILVL = "ilvl";
    private static final String NUM_ID = "numId";
    private static final String TC = "tc";
    private static final String TR = "tr";
    private static final String I = "i";
    private static final String U = "u";
    private static final String STRIKE = "strike";
    private static final String NUM_PR = "numPr";
    private static final String BR = "br";
    private static final String HYPERLINK = "hyperlink";
    private static final String HLINK_CLICK = "hlinkClick";
    private static final String TBL = "tbl";
    private static final String PIC = "pic";
    private static final String PICT = "pict";
    private static final String IMAGEDATA = "imagedata";
    private static final String BLIP = "blip";
    private static final String CHOICE = "Choice";
    private static final String FALLBACK = "Fallback";
    private static final String OLE_OBJECT = "OLEObject";
    private static final String CR = "cr";
    private static final String V = "v";
    private static final String RUBY = "ruby";
    private static final String RT = "rt";
    private static final String VAL = "val";
    private static final String MC_NS = "http://schemas.openxmlformats.org/markup-compatibility/2006";
    private static final String O_NS = "urn:schemas-microsoft-com:office:office";
    private static final String PIC_NS = "http://schemas.openxmlformats.org/drawingml/2006/picture";
    private static final String DRAWING_MAIN_NS = "http://schemas.openxmlformats.org/drawingml/2006/main";
    private static final String V_NS = "urn:schemas-microsoft-com:vml";
    private static final String C_NS = "http://schemas.openxmlformats.org/drawingml/2006/chart";
    private static final String OFFICE_DOC_RELATIONSHIP_NS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    private static final char[] TAB_CHAR = new char[]{'\t'};
    private static final char NEWLINE = '\n';
    private static final String BOOKMARK_START = "bookmarkStart";
    private static final String BOOKMARK_END = "bookmarkEnd";
    private static final String FOOTNOTE_REFERENCE = "footnoteReference";
    private static final String INS = "ins";
    private static final String DEL = "del";
    private static final String DEL_TEXT = "delText";
    private static final String MOVE_FROM = "moveFrom";
    private static final String MOVE_TO = "moveTo";
    private static final String ENDNOTE_REFERENCE = "endnoteReference";
    private static final String TEXTBOX = "textbox";
    private final XWPFBodyContentsHandler bodyContentsHandler;
    private final Map<String, String> linkedRelationships;
    private final RunProperties currRunProperties = new RunProperties();
    private final ParagraphProperties currPProperties = new ParagraphProperties();
    private final boolean includeTextBox;
    private final boolean concatenatePhoneticRuns;
    private final StringBuilder runBuffer = new StringBuilder();
    private final StringBuilder rubyBuffer = new StringBuilder();
    private boolean inR = false;
    private boolean inT = false;
    private boolean inRPr = false;
    private boolean inNumPr = false;
    private boolean inRt = false;
    private boolean inPic = false;
    private boolean inPict = false;
    private String picDescription = null;
    private String picRId = null;
    private String picFilename = null;
    private boolean lastStartElementWasP = false;
    private boolean pStarted = false;
    private int inACChoiceDepth = 0;
    private int inACFallbackDepth = 0;
    private boolean inDelText = false;
    private boolean inHlinkClick = false;
    private boolean inTextBox = false;
    private boolean inV = false;
    private EditType editType = EditType.NONE;
    private DateUtils dateUtils = new DateUtils();

    public OOXMLWordAndPowerPointTextHandler(XWPFBodyContentsHandler bodyContentsHandler, Map<String, String> hyperlinks) {
        this(bodyContentsHandler, hyperlinks, true, true);
    }

    public OOXMLWordAndPowerPointTextHandler(XWPFBodyContentsHandler bodyContentsHandler, Map<String, String> hyperlinks, boolean includeTextBox, boolean concatenatePhoneticRuns) {
        this.bodyContentsHandler = bodyContentsHandler;
        this.linkedRelationships = hyperlinks;
        this.includeTextBox = includeTextBox;
        this.concatenatePhoneticRuns = concatenatePhoneticRuns;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.lastStartElementWasP && !PPR.equals(localName)) {
            this.bodyContentsHandler.startParagraph(this.currPProperties);
        }
        this.lastStartElementWasP = false;
        if (uri != null && uri.equals(MC_NS)) {
            if (CHOICE.equals(localName)) {
                ++this.inACChoiceDepth;
            } else if (FALLBACK.equals(localName)) {
                ++this.inACFallbackDepth;
            }
        }
        if (this.inACChoiceDepth > 0) {
            return;
        }
        if (!this.includeTextBox && localName.equals(TEXTBOX)) {
            this.inTextBox = true;
            return;
        }
        if (RPR.equals(localName)) {
            this.inRPr = true;
        } else if (R.equals(localName)) {
            this.inR = true;
        } else if (T.equals(localName)) {
            this.inT = true;
        } else if (TAB.equals(localName)) {
            this.runBuffer.append(TAB_CHAR);
        } else if (P.equals(localName)) {
            this.lastStartElementWasP = true;
        } else if (B.equals(localName)) {
            if (this.inR && this.inRPr) {
                this.currRunProperties.setBold(true);
            }
        } else if (TC.equals(localName)) {
            this.bodyContentsHandler.startTableCell();
        } else if (P_STYLE.equals(localName)) {
            String styleId = atts.getValue(W_NS, VAL);
            this.currPProperties.setStyleID(styleId);
        } else if (I.equals(localName)) {
            if (this.inR && this.inRPr) {
                this.currRunProperties.setItalics(true);
            }
        } else if (STRIKE.equals(localName)) {
            if (this.inR && this.inRPr) {
                this.currRunProperties.setStrike(true);
            }
        } else if (U.equals(localName)) {
            if (this.inR && this.inRPr) {
                this.currRunProperties.setUnderline(this.getStringVal(atts));
            }
        } else if (TR.equals(localName)) {
            this.bodyContentsHandler.startTableRow();
        } else if (NUM_PR.equals(localName)) {
            this.inNumPr = true;
        } else if (ILVL.equals(localName)) {
            if (this.inNumPr) {
                this.currPProperties.setIlvl(this.getIntVal(atts));
            }
        } else if (NUM_ID.equals(localName)) {
            if (this.inNumPr) {
                this.currPProperties.setNumId(this.getIntVal(atts));
            }
        } else if (BR.equals(localName)) {
            this.runBuffer.append('\n');
        } else if (BOOKMARK_START.equals(localName)) {
            String name = atts.getValue(W_NS, "name");
            String id = atts.getValue(W_NS, "id");
            this.bodyContentsHandler.startBookmark(id, name);
        } else if (BOOKMARK_END.equals(localName)) {
            String id = atts.getValue(W_NS, "id");
            this.bodyContentsHandler.endBookmark(id);
        } else if (HYPERLINK.equals(localName)) {
            String hyperlinkId = atts.getValue(OFFICE_DOC_RELATIONSHIP_NS, "id");
            String hyperlink = null;
            if (hyperlinkId != null) {
                hyperlink = this.linkedRelationships.get(hyperlinkId);
                this.bodyContentsHandler.hyperlinkStart(hyperlink);
            } else {
                Object anchor = atts.getValue(W_NS, "anchor");
                if (anchor != null) {
                    anchor = "#" + (String)anchor;
                }
                this.bodyContentsHandler.hyperlinkStart((String)anchor);
            }
        } else if (HLINK_CLICK.equals(localName)) {
            String hyperlinkId = atts.getValue(OFFICE_DOC_RELATIONSHIP_NS, "id");
            String hyperlink = null;
            if (hyperlinkId != null) {
                hyperlink = this.linkedRelationships.get(hyperlinkId);
                this.bodyContentsHandler.hyperlinkStart(hyperlink);
                this.inHlinkClick = true;
            }
        } else if (TBL.equals(localName)) {
            this.bodyContentsHandler.startTable();
        } else if (BLIP.equals(localName)) {
            this.picRId = atts.getValue(OFFICE_DOC_RELATIONSHIP_NS, "embed");
        } else if ("cNvPr".equals(localName)) {
            this.picDescription = atts.getValue("", "descr");
        } else if (PIC.equals(localName)) {
            this.inPic = true;
        } else if (FOOTNOTE_REFERENCE.equals(localName)) {
            String id = atts.getValue(W_NS, "id");
            this.bodyContentsHandler.footnoteReference(id);
        } else if (IMAGEDATA.equals(localName)) {
            this.picRId = atts.getValue(OFFICE_DOC_RELATIONSHIP_NS, "id");
            this.picDescription = atts.getValue(O_NS, "title");
        } else if (INS.equals(localName)) {
            this.startEditedSection(EditType.INSERT, atts);
        } else if (DEL_TEXT.equals(localName)) {
            this.inDelText = true;
        } else if (DEL.equals(localName)) {
            this.startEditedSection(EditType.DELETE, atts);
        } else if (MOVE_TO.equals(localName)) {
            this.startEditedSection(EditType.MOVE_TO, atts);
        } else if (MOVE_FROM.equals(localName)) {
            this.startEditedSection(EditType.MOVE_FROM, atts);
        } else if (OLE_OBJECT.equals(localName)) {
            String type = null;
            String refId = null;
            for (int i = 0; i < atts.getLength(); ++i) {
                String attLocalName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (attLocalName.equals("Type")) {
                    type = attValue;
                    continue;
                }
                if (!OFFICE_DOC_RELATIONSHIP_NS.equals(atts.getURI(i)) || !attLocalName.equals("id")) continue;
                refId = attValue;
            }
            if ("Embed".equals(type)) {
                this.bodyContentsHandler.embeddedOLERef(refId);
            }
        } else if (CR.equals(localName)) {
            this.runBuffer.append('\n');
        } else if (ENDNOTE_REFERENCE.equals(localName)) {
            String id = atts.getValue(W_NS, "id");
            this.bodyContentsHandler.endnoteReference(id);
        } else if (V.equals(localName) && C_NS.equals(uri)) {
            this.inV = true;
        } else if (RT.equals(localName)) {
            this.inRt = true;
        }
    }

    private void startEditedSection(EditType editType, Attributes atts) throws SAXException {
        String editAuthor = atts.getValue(W_NS, "author");
        String editDateString = atts.getValue(W_NS, "date");
        Date editDate = null;
        if (editDateString != null) {
            editDate = this.dateUtils.tryToParse(editDateString);
        }
        this.bodyContentsHandler.startEditedSection(editAuthor, editDate, editType);
        this.editType = editType;
    }

    private String getStringVal(Attributes atts) {
        String valString = atts.getValue(W_NS, VAL);
        if (valString != null) {
            return valString;
        }
        return "";
    }

    private int getIntVal(Attributes atts) {
        String valString = atts.getValue(W_NS, VAL);
        if (valString != null) {
            try {
                return Integer.parseInt(valString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (CHOICE.equals(localName)) {
            --this.inACChoiceDepth;
        } else if (FALLBACK.equals(localName)) {
            --this.inACFallbackDepth;
        }
        if (this.inACChoiceDepth > 0) {
            return;
        }
        if (!this.includeTextBox && localName.equals(TEXTBOX)) {
            this.inTextBox = false;
            return;
        }
        if (PIC.equals(localName)) {
            this.handlePict();
            this.inPic = false;
            return;
        }
        if (RPR.equals(localName)) {
            this.inRPr = false;
        } else if (R.equals(localName)) {
            this.handleEndOfRun();
        } else if (T.equals(localName)) {
            this.inT = false;
        } else if (PPR.equals(localName)) {
            if (!this.pStarted) {
                this.bodyContentsHandler.startParagraph(this.currPProperties);
                this.pStarted = true;
            }
            this.currPProperties.reset();
        } else if (P.equals(localName)) {
            if (this.runBuffer.length() > 0) {
                this.bodyContentsHandler.run(this.currRunProperties, this.runBuffer.toString());
                this.runBuffer.setLength(0);
            }
            this.pStarted = false;
            this.bodyContentsHandler.endParagraph();
        } else if (TC.equals(localName)) {
            this.bodyContentsHandler.endTableCell();
        } else if (TR.equals(localName)) {
            this.bodyContentsHandler.endTableRow();
        } else if (TBL.equals(localName)) {
            this.bodyContentsHandler.endTable();
        } else if (FLD.equals(localName)) {
            this.handleEndOfRun();
        } else if (DEL_TEXT.equals(localName)) {
            this.inDelText = false;
        } else if (INS.equals(localName) || DEL.equals(localName) || MOVE_TO.equals(localName) || MOVE_FROM.equals(localName)) {
            this.editType = EditType.NONE;
        } else if (HYPERLINK.equals(localName)) {
            this.bodyContentsHandler.hyperlinkEnd();
        } else if (PICT.equals(localName)) {
            this.handlePict();
        } else if (V.equals(localName) && C_NS.equals(uri)) {
            this.inV = false;
            this.handleEndOfRun();
        } else if (RT.equals(localName)) {
            this.inRt = false;
        } else if (RUBY.equals(localName)) {
            this.handleEndOfRuby();
        }
    }

    private void handleEndOfRuby() throws SAXException {
        if (this.rubyBuffer.length() > 0) {
            if (this.concatenatePhoneticRuns) {
                this.bodyContentsHandler.run(this.currRunProperties, " (" + this.rubyBuffer.toString() + ")");
            }
            this.rubyBuffer.setLength(0);
        }
    }

    private void handleEndOfRun() throws SAXException {
        this.bodyContentsHandler.run(this.currRunProperties, this.runBuffer.toString());
        if (this.inHlinkClick) {
            this.bodyContentsHandler.hyperlinkEnd();
            this.inHlinkClick = false;
        }
        this.inR = false;
        this.runBuffer.setLength(0);
        this.currRunProperties.setBold(false);
        this.currRunProperties.setItalics(false);
        this.currRunProperties.setStrike(false);
        this.currRunProperties.setUnderline(UnderlinePatterns.NONE.name());
    }

    private void handlePict() throws SAXException {
        String picFileName = null;
        if (this.picRId != null) {
            picFileName = this.linkedRelationships.get(this.picRId);
        }
        this.bodyContentsHandler.embeddedPicRef(picFileName, this.picDescription);
        this.picDescription = null;
        this.picRId = null;
        this.inPic = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inACChoiceDepth > 0) {
            return;
        }
        if (!this.includeTextBox && this.inTextBox) {
            return;
        }
        if (this.editType.equals((Object)EditType.MOVE_FROM) && this.inT) {
            if (this.bodyContentsHandler.isIncludeMoveFromText()) {
                this.appendToBuffer(ch, start, length);
            }
        } else if (this.inT) {
            this.appendToBuffer(ch, start, length);
        } else if (this.bodyContentsHandler.isIncludeDeletedText() && this.editType.equals((Object)EditType.DELETE)) {
            this.appendToBuffer(ch, start, length);
        } else if (this.inV) {
            this.appendToBuffer(ch, start, length);
            this.appendToBuffer(TAB_CHAR, 0, 1);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.inACChoiceDepth > 0) {
            return;
        }
        if (!this.includeTextBox && this.inTextBox) {
            return;
        }
        if (this.inT) {
            this.appendToBuffer(ch, start, length);
        } else if (this.bodyContentsHandler.isIncludeDeletedText() && this.inDelText) {
            this.appendToBuffer(ch, start, length);
        }
    }

    private void appendToBuffer(char[] ch, int start, int length) throws SAXException {
        if (this.inRt) {
            this.rubyBuffer.append(ch, start, length);
        } else {
            this.runBuffer.append(ch, start, length);
        }
    }

    public static interface XWPFBodyContentsHandler {
        public void run(RunProperties var1, String var2) throws SAXException;

        public void hyperlinkStart(String var1) throws SAXException;

        public void hyperlinkEnd() throws SAXException;

        public void startParagraph(ParagraphProperties var1) throws SAXException;

        public void endParagraph() throws SAXException;

        public void startTable() throws SAXException;

        public void endTable() throws SAXException;

        public void startTableRow() throws SAXException;

        public void endTableRow() throws SAXException;

        public void startTableCell() throws SAXException;

        public void endTableCell() throws SAXException;

        public void startSDT() throws SAXException;

        public void endSDT() throws SAXException;

        public void startEditedSection(String var1, Date var2, EditType var3) throws SAXException;

        public void endEditedSection() throws SAXException;

        public boolean isIncludeDeletedText() throws SAXException;

        public void footnoteReference(String var1) throws SAXException;

        public void endnoteReference(String var1) throws SAXException;

        public boolean isIncludeMoveFromText() throws SAXException;

        public void embeddedOLERef(String var1) throws SAXException;

        public void embeddedPicRef(String var1, String var2) throws SAXException;

        public void startBookmark(String var1, String var2) throws SAXException;

        public void endBookmark(String var1) throws SAXException;
    }

    public static enum EditType {
        NONE,
        INSERT,
        DELETE,
        MOVE_TO,
        MOVE_FROM;

    }
}

