/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.Line;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class GpxRouteLayer
extends AbstractModifiableLayer {
    public final GpxLayer fromLayer;
    private final Collection<GpxRoute> routes = new ArrayList<GpxRoute>();

    public GpxRouteLayer() {
        this(null, null);
    }

    public GpxRouteLayer(String name, GpxLayer fromLayer) {
        super(name);
        this.fromLayer = fromLayer;
        if (fromLayer != null) {
            this.routes.addAll(fromLayer.data.routes);
        }
    }

    @Override
    public boolean isModified() {
        return this.fromLayer.isModified();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getToolTipText() {
        String tooltip = I18n.trn("{0} route, ", "{0} routes, ", this.routes.size(), this.routes.size());
        return Utils.strip(tooltip, " ,");
    }

    @Override
    public void mergeFrom(Layer from) {
        if (from instanceof GpxRouteLayer) {
            this.routes.addAll(((GpxRouteLayer)from).routes);
        }
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GpxRouteLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        this.fromLayer.visitBoundingBox(v);
    }

    @Override
    public Object getInfoComponent() {
        return null;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[0];
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
    }

    @Override
    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent event) {
        return new GpxDrawHelper(this.fromLayer){

            @Override
            protected Iterable<Line> getLinesIterable(boolean[] trackVisibility) {
                return () -> GpxRouteLayer.this.routes.stream().map(Line::new).iterator();
            }
        };
    }
}

