import ts from 'typescript';
import { DocumentSnapshot, JSOrTSDocumentSnapshot } from './DocumentSnapshot';
import { TextDocumentContentChangeEvent } from 'vscode-languageserver';
type SnapshotChangeHandler = (fileName: string, newDocument: DocumentSnapshot | undefined) => void;
/**
 * Every snapshot corresponds to a unique file on disk.
 * A snapshot can be part of multiple projects, but for a given file path
 * there can be only one snapshot.
 */
export declare class GlobalSnapshotsManager {
    private readonly tsSystem;
    private emitter;
    private documents;
    private getCanonicalFileName;
    constructor(tsSystem: ts.System);
    get(fileName: string): DocumentSnapshot | undefined;
    getByPrefix(path: string): DocumentSnapshot[];
    set(fileName: string, document: DocumentSnapshot): void;
    delete(fileName: string): void;
    updateTsOrJsFile(fileName: string, changes?: TextDocumentContentChangeEvent[]): JSOrTSDocumentSnapshot | undefined;
    onChange(listener: SnapshotChangeHandler): void;
    removeChangeListener(listener: SnapshotChangeHandler): void;
}
export interface TsFilesSpec {
    include?: readonly string[];
    exclude?: readonly string[];
}
/**
 * Should only be used by `service.ts`
 */
export declare class SnapshotManager {
    private globalSnapshotsManager;
    private fileSpec;
    private workspaceRoot;
    private readonly documents;
    private lastLogged;
    private readonly projectFileToOriginalCasing;
    private getCanonicalFileName;
    private readonly watchExtensions;
    constructor(globalSnapshotsManager: GlobalSnapshotsManager, fileSpec: TsFilesSpec, workspaceRoot: string, projectFiles: string[], useCaseSensitiveFileNames?: boolean);
    private onSnapshotChange;
    updateProjectFiles(): void;
    updateTsOrJsFile(fileName: string, changes?: TextDocumentContentChangeEvent[]): void;
    has(fileName: string): boolean;
    set(fileName: string, snapshot: DocumentSnapshot): void;
    get(fileName: string): DocumentSnapshot | undefined;
    delete(fileName: string): void;
    getFileNames(): string[];
    getProjectFileNames(): string[];
    private logStatistics;
    dispose(): void;
}
export declare const ignoredBuildDirectories: string[];
export {};
