PK
     ngUE  E  
  ExpatTests.stUT	 hchcux     "======================================================================
|
|   Expat-based XML parser tests
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"



XMLPullParserTest subclass: ExpatXMLPullParserTest [
    
    <comment: 'I test the expat pull parser directly.'>
    <category: 'ExpatPullParser'>

    parserOn: source [
	<category: 'instance creation'>
	^ExpatXMLPullParser onString: source.
    ]
]

XMLPullParserTest subclass: ExpatXMLParserTest [
    
    <comment: 'I test the expat push parser by wrapping it again
with the generator-based generic pull parser.'>
    <category: 'ExpatPullParser'>

    parserOn: source [
	<category: 'instance creation'>
	^XMLGenerativePullParser
	    onParser: (ExpatXMLParser onString: source)
    ]
]

PK
     ngU.,  ,    ExpatParser.stUT	 hchcux     "======================================================================
|
|   Push adaptor for Expat XML Parser
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"



SAXParser subclass: ExpatXMLParser [
    | pullParser |
    
    <comment: 'A push parser based on Expat.  This uses the pull
parser and serializes the events to the SAX driver.'>
    <category: 'XML-XML-Parsing'>

    ExpatXMLParser class >> pullParserOn: dataSource [
	"Use the expat pull parser directly, without going through
	 pull on push on pull... which we do for the test suite! :-)"

	<category: 'instance creation'>
	^ExpatXMLPullParser on: dataSource
    ]

    on: dataSource [
	"The dataSource may be a URI, a Filename (or a String
	 which will be treated as a Filename), or an InputSource."

	<category: 'initialize'>
	super on: dataSource.

	"As the underlying parser we use the event-based Expat bindings.
	 We need to get all the events in order to pass them to the user's
	 own driver."
	pullParser := ExpatXMLPullParser on: dataSource.
	pullParser needComments: true.
	pullParser needDTDEvents: true.
	pullParser needCdataDelimiters: true.
	pullParser needPrefixMappingEvents: true.
    ]

    scanDocument [
	"Serialize the events from the pull parser to the SAX driver."

	<category: 'api'>
	[pullParser do: [ :event | event serializeTo: sax]]
		on: XMLResolveEntityNotification
		do: [ :e | e resume:
		    (sax resolveEntity: e publicID systemID: e systemID) ];

		on: MalformedSignal, BadCharacterSignal
		do: [ :e | sax fatalError: e ];

		on: InvalidSignal
		do: [ :e | sax nonFatalError: e ];

		on: WarningSignal
		do: [ :e | sax warning: e ]
    ]
]


Eval [
    SAXParser defaultParserClass isNil
	ifTrue: [SAXParser defaultParserClass: ExpatXMLParser].
]

PK
     ngUqK      ExpatPullParser.stUT	 hchcux     "======================================================================
|
|   Expat-based pull parser
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"



Object subclass: SAXEventSequence [
    | event next |

    <category: 'XML-Expat'>
    <comment: 'I represent a circular linked list used when expat
communicates more than one event between its resumption and when it
is stopped again.'>

    event [
	<category: 'accessing'>
	^event
    ]

    event: anObject [
	<category: 'accessing'>
	event := anObject
    ]

    initialize [
	<category: 'initialization'>
	next := self.
    ]

    isEmpty [
	<category: 'testing'>
	^next == self
    ]

    next [
	<category: 'accessing'>
	^next
    ]

    next: aSAXList [
	<category: 'accessing'>
	next := aSAXList.
    ]
]



CObject subclass: XMLExpatParserObject [

    <category: 'XML-Expat'>
    <comment: 'I wrap an expat XML_Parser object.  The creation is
mediated by the C support module, so that the appropriate event
handlers are set.'>

    XMLExpatParserObject class >> errorString: code [
	<category: 'C callouts'>
	<cCall: 'XML_ErrorString' returning: #string args: #(#int)>
    ]

    XMLExpatParserObject class >> createFor: anObject [
	<category: 'C callouts'>
	<cCall: 'gst_XML_ParserCreate' returning: #{XMLExpatParserObject}
	    args: #(#smalltalk)>
    ]

    externalEntityParser: contextString encoding: aString [
	<category: 'C callouts'>
	<cCall: 'XML_ExternalEntityParserCreate'
	    returning: #{XMLExpatParserObject} args: #(#self #string #unknown)>
    ]

    free [
	<category: 'C callouts'>
	<cCall: 'XML_ParserFree' returning: #void args: #(#self)>
    ]

    parse: aString len: len isFinal: aBoolean [
	<category: 'C callouts'>
	<cCall: 'XML_Parse' returning: #int args: #(#self #string #int #boolean)>
    ]

    errorCode [
	<category: 'C callouts'>
	<cCall: 'XML_GetErrorCode' returning: #int args: #(#self)>
    ]

    errorString [
	<category: 'error reporting'>
	^self class errorString: self errorCode
    ]

    resume [
	<category: 'C callouts'>
	<cCall: 'XML_ResumeParser' returning: #int args: #(#self)>
    ]

    userData [
	<category: 'C macros'>
	^(self castTo: ##(CObject type ptrType)) value
    ]

    userData: aCObject [
	<category: 'C callouts'>
	<cCall: 'XML_SetUserData' returning: #void args: #(#self #unknown)>
    ]
]



SAXExternalDecl subclass: SAXExternalEntityRef [
    | context |

    <category: 'XML-Expat'>
    <comment: 'This is a dummy event used to trigger creation of a
nested parser.  It is never pushed down; it is only used to trigger
the XMLResolveEntityNotification.'>

    neededBy: aParser [
	<category: 'entity resolution'>
	| entity |
        entity := XMLResolveEntityNotification new
	    publicID: self publicID;
	    systemID: self systemID;
	    signal.
	entity isNil ifFalse: [ aParser push: entity stream context: context ].
	^false
    ]

    serializeTo: sax [
	^sax resolveEntity: self publicID systemID: self systemID
    ]
]



XMLPullParser subclass: ExpatXMLPullParser [
    <category: 'XML-Expat'>
    <comment: 'This is a pull parser wrapping the expat library.
expat parsers are "push" style, but we change it to "pull" using
XML_StopParser in order to avoid complicating the code with callbacks
from C to Smalltalk.'>

    | xp nextParser current pending source sourceStack buffer first |

    ExpatXMLPullParser class >> on: source [
	<category: 'instance creation'>
	^self new initialize: source
    ]

    atEnd [
	<category: 'core api'>
	^source isNil
    ]

    current [
	<category: 'core api'>
	^current
    ]

    initialize: aSource [
	<category: 'initialize-release'>
	| input uri |
        input := (aSource isKindOf: Stream)
                    ifTrue:
                        [uri := [NetClients.URL fromString: aSource name] on: Error
                                    do: [:ex | ex return: nil].
                        InputSource
                            uri: uri
                            encoding: nil
                            stream: aSource]
                    ifFalse: [InputSource for: aSource].

	sourceStack := OrderedCollection new.
	source := input stream.

	buffer := String new: 1024.
	xp := XMLExpatParserObject createFor: self.
	self addToBeFinalized.

	"Insert the first event."
	pending := SAXEventSequence new.
	current := SAXStartDocument new.
	first := true.
    ]

    finalize [
	"Free the whole parser chain."

	<category: 'finalization'>
	[ xp isNil ] whileFalse: [ self pop ]
    ]

    push: aStream context: context [
	"Push a new parser for the given stream.  The context comes
	 from the ExternalEntityRefHandler and is passed down to
	 XML_ExternalEntityParserCreate."

	<category: 'entity resolution'>
	| userData |
	sourceStack add: source.
	source := aStream.
	first := true.

	"The userData of suspended parsers constitutes a list of parsers,
	 with nextParser as the head."
	userData := xp userData.
	xp userData: nextParser.
	nextParser := xp.

	xp := xp externalEntityParser: context encoding: nil.

	"Move the suspended parser's userData to the new one."
	xp userData: userData.
    ]

    pop [
	"Switch back to the parent parser of XP, which is stored
	 in nextParser."

	<category: 'entity resolution'>
	| userData oldParser |
	oldParser := xp.
	xp := nextParser.
	xp isNil
	    ifTrue: [
		self removeToBeFinalized.
		source := nil.
		current := SAXEndDocument new ]
	    ifFalse: [
	        source := sourceStack removeLast.
	        nextParser := xp userData ifNotNil: [ :u |
		    u castTo: XMLExpatParserObject type ].
	        xp userData: self ].
	oldParser free.
    ]

    parseMore [
	"Pass data from the source to the XML_Parser."

	<category: 'parsing'>
	| len |
	len := source nextAvailable: buffer size into: buffer startingAt: 1.
	^xp
	    parse: buffer
	    len: len
	    isFinal: source atEnd
    ]

    raiseError [
	"Convert an Expat error to a Smalltalk exception."

	<category: 'parsing'>
	| code |
	code := xp errorCode.
	code = 3
	    ifTrue: [ EmptySignal signal ]
	    ifFalse: [ MalformedSignal signal: (xp class errorString: code) ].

	self removeToBeFinalized; finalize
    ]

    advance [
	"Call the underlying parser, retrieving events and popping the
	 current parser when the data source is exhausted."

	<category: 'private api'>
	| result |
	"First try removing the head of the pending event queue.
	 PENDING points to the tail of a circular list, and is
	 just a sentinel node."
	pending isEmpty ifFalse: [
	    current := pending next event.
	    pending next event: nil.
	    pending next: pending next next.
	    ^self ].

	"See if we're done."
	self atEnd ifTrue: [^self].

	"Start parsing.  On the first call we need to do #parseMore."
	current := nil. 
	result := first
	    ifTrue: [ first := false. self parseMore ]
	    ifFalse: [ xp resume ].

	[ result = 2 ] whileFalse: [
	    result = 0 ifTrue: [ ^self raiseError; current ].
	    result := source atEnd
		ifTrue: [
		    self pop. 
		    current isNil ifFalse: [ 2 ] ifTrue: [ xp resume ] ]
		ifFalse: [ self parseMore ]
	].
	^current
    ]
]
PK
     8ogUg
  
    package.xmlUT	  ic icux     <package>
  <name>XML-Expat</name>
  <namespace>XML</namespace>
  <test>
    <namespace>XML</namespace>
    <prereq>SUnit</prereq>
    <prereq>XML-Expat</prereq>
    <prereq>XML-ParserTests</prereq>
    <sunit>XML.ExpatXMLPullParserTest XML.ExpatXMLParserTest</sunit>
    <filein>ExpatTests.st</filein>
  </test>
  <provides>XML-Parser</provides>
  <prereq>XML-PullParser</prereq>
  <prereq>XML-SAXParser</prereq>
  <module>expat</module>

  <filein>ExpatPullParser.st</filein>
  <filein>ExpatParser.st</filein>
</package>PK
     ngUE  E  
              ExpatTests.stUT hcux     PK
     ngU.,  ,              ExpatParser.stUT hcux     PK
     ngUqK                 ExpatPullParser.stUT hcux     PK
     8ogUg
  
            33  package.xmlUT  icux     PK      P  5    