from _typeshed import Incomplete
from typing import Any

from ..util.langhelpers import memoized_property

class ScopedSessionMixin:
    def __call__(self, **kw): ...
    def configure(self, **kwargs) -> None: ...

class scoped_session(ScopedSessionMixin):
    session_factory: Any
    registry: Any
    def __init__(self, session_factory, scopefunc: Incomplete | None = None) -> None: ...
    def remove(self) -> None: ...
    def query_property(self, query_cls: Incomplete | None = None): ...
    # dynamically proxied from class Session
    bind: Any
    identity_map: Any
    autoflush: Any
    autocommit: bool
    @property
    def dirty(self): ...
    @property
    def deleted(self): ...
    @property
    def new(self): ...
    @property
    def is_active(self): ...
    @property
    def no_autoflush(self) -> None: ...
    @memoized_property
    def info(self): ...
    @classmethod
    def close_all(cls) -> None: ...
    @classmethod
    def identity_key(cls, *args, **kwargs): ...
    @classmethod
    def object_session(cls, instance): ...
    def __contains__(self, instance): ...
    def __iter__(self): ...
    def add(self, instance, _warn: bool = True) -> None: ...
    def add_all(self, instances) -> None: ...
    def begin(self, subtransactions: bool = False, nested: bool = False, _subtrans: bool = False): ...
    def begin_nested(self): ...
    def close(self) -> None: ...
    def commit(self) -> None: ...
    def connection(
        self,
        bind_arguments: Incomplete | None = None,
        close_with_result: bool = False,
        execution_options: Incomplete | None = None,
        **kw,
    ): ...
    def delete(self, instance) -> None: ...
    def execute(
        self,
        statement,
        params: Incomplete | None = None,
        execution_options=...,
        bind_arguments: Incomplete | None = None,
        _parent_execute_state: Incomplete | None = None,
        _add_event: Incomplete | None = None,
        **kw,
    ): ...
    def expire(self, instance, attribute_names: Incomplete | None = None) -> None: ...
    def expire_all(self) -> None: ...
    def expunge(self, instance) -> None: ...
    def expunge_all(self) -> None: ...
    def flush(self, objects: Incomplete | None = None) -> None: ...
    def get(
        self,
        entity,
        ident,
        options: Incomplete | None = None,
        populate_existing: bool = False,
        with_for_update: Incomplete | None = None,
        identity_token: Incomplete | None = None,
        execution_options: Incomplete | None = None,
    ): ...
    def get_bind(
        self,
        mapper: Incomplete | None = None,
        clause: Incomplete | None = None,
        bind: Incomplete | None = None,
        _sa_skip_events: Incomplete | None = None,
        _sa_skip_for_implicit_returning: bool = False,
    ): ...
    def is_modified(self, instance, include_collections: bool = True): ...
    def bulk_save_objects(
        self, objects, return_defaults: bool = False, update_changed_only: bool = True, preserve_order: bool = True
    ): ...
    def bulk_insert_mappings(self, mapper, mappings, return_defaults: bool = False, render_nulls: bool = False) -> None: ...
    def bulk_update_mappings(self, mapper, mappings) -> None: ...
    def merge(self, instance, load: bool = True, options: Incomplete | None = None): ...
    def query(self, *entities, **kwargs): ...
    def refresh(self, instance, attribute_names: Incomplete | None = None, with_for_update: Incomplete | None = None) -> None: ...
    def rollback(self) -> None: ...
    def scalar(
        self, statement, params: Incomplete | None = None, execution_options=..., bind_arguments: Incomplete | None = None, **kw
    ): ...
    def scalars(
        self, statement, params: Incomplete | None = None, execution_options=..., bind_arguments: Incomplete | None = None, **kw
    ): ...

ScopedSession = scoped_session
