/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
import { Socket } from 'net';
import * as tls from 'tls';
import TypedEmitter from "typed-emitter";
import { ClientEvents } from './events';
export interface ChanData {
    created?: string;
    key: string;
    serverName: string;
    /**
     * nick => mode
     */
    users: Map<string, string>;
    mode: string;
    modeParams: {
        [mode: string]: string[];
    };
    topic?: string;
    topicBy?: string;
}
export interface ChanListItem {
    name: string;
    users: string;
    topic: string;
}
export interface WhoisResponse {
    nick: string;
    user?: string;
    channels?: string[];
    host?: string;
    realname?: string;
    away?: string;
    idle?: string;
    server?: string;
    serverinfo?: string;
    operator?: string;
    account?: string;
    accountinfo?: string;
    realHost?: string;
}
export interface IrcClientOpts {
    password?: string | null;
    userName?: string;
    realName?: string;
    port?: number;
    family?: 4 | 6 | null;
    bustRfc3484?: boolean;
    localAddress?: string | null;
    localPort?: number | null;
    debug?: boolean;
    showErrors?: boolean;
    autoRejoin?: boolean;
    autoConnect?: boolean;
    channels?: string[];
    retryCount?: number | null;
    retryDelay?: number;
    secure?: boolean | tls.ConnectionOptions;
    selfSigned?: boolean;
    certExpired?: boolean;
    floodProtection?: boolean;
    floodProtectionDelay?: number;
    sasl?: boolean;
    saslType?: 'PLAIN' | 'EXTERNAL';
    stripColors?: boolean;
    channelPrefixes?: string;
    messageSplit?: number;
    encoding?: string | false;
    encodingFallback?: string;
    onNickConflict?: (maxLen?: number) => string;
    webirc?: {
        pass: string;
        ip: string;
        user: string;
        host?: string;
    };
    nickMod?: number;
}
interface IrcSupported {
    channel: {
        idlength: {
            [key: string]: string;
        };
        length: number;
        limit: {
            [key: string]: number;
        };
        modes: {
            /**
             * Always take a parameter when specified by the server.
             * May have a parameter when specificed by the client.
             */
            a: string;
            /**
             * Alwyas take a parameter.
             */
            b: string;
            /**
             * Take a parameter when set, absent when removed.
             */
            c: string;
            /**
             * Never take a parameter.
             */
            d: string;
        };
        types: string;
    };
    maxlist: {
        [key: string]: number;
    };
    maxtargets: {
        [key: string]: number;
    };
    modes: number;
    nicklength: number;
    topiclength: number;
    kicklength: number;
    usermodes: string;
    usermodepriority: string;
    casemapping: 'ascii' | 'rfc1459' | 'strict-rfc1459';
    extra: string[];
}
export declare type SaslErrors = "err_saslfail" | "err_sasltoolong" | "err_saslaborted" | "err_saslalready";
declare const Client_base: new () => TypedEmitter<ClientEvents>;
export declare class Client extends Client_base {
    private server;
    private sendingPromise;
    private lastSendTime;
    private nickMod;
    private opt;
    private hostMask;
    private prevClashNick;
    private _maxLineLength;
    conn?: Socket | tls.TLSSocket;
    private requestedDisconnect;
    private supportedState;
    private capabilities;
    private loggedIn;
    /**
     * Cached data
     */
    private whoisData;
    chans: Map<string, ChanData>;
    readonly prefixForMode: {
        [mode: string]: string;
    };
    readonly modeForPrefix: {
        [prefix: string]: string;
    };
    /**
     * These variables are used to build up state and should be discarded after use.
     */
    private motd?;
    private channelListState?;
    /**
     * This will either be the requested nick or the actual nickname.
     */
    private currentNick;
    get nick(): string;
    get supported(): IrcSupported;
    get maxLineLength(): number;
    /**
     * Check if the user is logged in (for SASL supporting servers).
     * This will be null if this could not be determined.
     */
    get isLoggedIn(): boolean | null;
    constructor(server: string, requestedNick: string, opt: IrcClientOpts);
    private onCapsList;
    private onCapsConfirmed;
    private onReplyWelcome;
    private onReplyMyInfo;
    private onReplyISupport;
    private onErrNicknameInUse;
    private onNotice;
    private onMode;
    private onNick;
    private onMotdData;
    private onReplyName;
    private onReplyNameEnd;
    private onReplyTopic;
    private onTopic;
    private onReplyChannelList;
    private onReplyTopicWho;
    private onReplyChannelMode;
    private onReplyCreationTime;
    private onJoin;
    private onPart;
    private onKick;
    private onKill;
    private onPrivateMessage;
    private onInvite;
    private onQuit;
    private onAuthenticate;
    private onBadNickname;
    private onRaw;
    private handleEndOfWhois;
    private onNickConflict;
    chanData(name: string, create?: boolean): ChanData | undefined;
    removeChanData(name: string): void;
    private _connectionHandler;
    connect(retryCountOrCallBack?: number | (() => void), callback?: () => void): void;
    private reconnect;
    disconnect(messageOrCallback?: string | (() => void), callback?: () => void): void;
    send(...command: string[]): Promise<void>;
    private _send;
    join(channel: string, callback?: (...args: unknown[]) => void): Promise<void>;
    part(channel: string, messageOrCallback: string | (() => void), callback?: () => void): Promise<void>;
    action(channel: string, text: string): Promise<void>;
    isUserPrefixMorePowerfulThan(prefix: string, testPrefix: string): boolean;
    say(target: string, text: string): Promise<void>;
    notice(target: string, text: string): Promise<void>;
    private _splitMessage;
    private _speak;
    getSplitMessages(target: string, text: string): string[];
    whois(nick: string, callback?: (info: WhoisResponse | null) => void): Promise<void>;
    names(channel: string, callback?: (callbackChannel: string, names: Map<string, string>) => void): Promise<void>;
    mode(channel: string, callback?: (callbackChannel: string, ...args: unknown[]) => void): Promise<void>;
    setUserMode(mode: string, nick?: string): Promise<void>;
    list(...args: string[]): Promise<void>;
    private _addWhoisData;
    private _clearWhoisData;
    private _handleCTCP;
    ctcp(to: string, type: string, text: string): Promise<void>;
    convertEncoding(buffer: Buffer): string;
    private _updateMaxLineLength;
    private _casemap;
    toLowerCase(str: string): string;
    private readyState;
}
export {};
