/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PropertyUtils {
    private static final Logger LOG = Logger.getLogger(PropertyUtils.class.getName());

    PropertyUtils() {
    }

    static String getSecurityProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(string);
            }
        });
    }

    static String getSystemProperty(final String string) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(string);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.WARNING, "Failed to get system property", runtimeException);
            return null;
        }
    }

    static boolean getBooleanSystemProperty(String string, boolean bl) {
        String string2 = PropertyUtils.getSystemProperty(string);
        if (null != string2) {
            if ("true".equals(string2)) {
                LOG.log(Level.INFO, "Found boolean system property [" + string + "]: " + true);
                return true;
            }
            if ("false".equals(string2)) {
                LOG.log(Level.INFO, "Found boolean system property [" + string + "]: " + false);
                return false;
            }
            LOG.log(Level.WARNING, "Unrecognized value for boolean system property [" + string + "]: " + string2);
        }
        LOG.log(Level.FINE, "Boolean system property [" + string + "] defaulted to: " + bl);
        return bl;
    }

    static int getIntegerSystemProperty(String string, int n, int n2, int n3) {
        String string2 = PropertyUtils.getSystemProperty(string);
        if (null != string2) {
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 >= n2 && n4 <= n3) {
                    LOG.log(Level.INFO, "Found integer system property [" + string + "]: " + n4);
                    return n4;
                }
                if (LOG.isLoggable(Level.WARNING)) {
                    String string3 = PropertyUtils.getRangeString(n2, n3);
                    LOG.log(Level.WARNING, "Out-of-range (" + string3 + ") integer system property [" + string + "]: " + string2);
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Unrecognized value for integer system property [" + string + "]: " + string2);
            }
        }
        LOG.log(Level.FINE, "Integer system property [" + string + "] defaulted to: " + n);
        return n;
    }

    static String getStringSystemProperty(String string) {
        String string2 = PropertyUtils.getSystemProperty(string);
        if (null != string2) {
            LOG.log(Level.INFO, "Found string system property [" + string + "]: " + string2);
            return string2;
        }
        return null;
    }

    private static String getRangeString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(32);
        if (Integer.MIN_VALUE != n) {
            stringBuilder.append(n);
            stringBuilder.append(" <= ");
        }
        stringBuilder.append('x');
        if (Integer.MAX_VALUE != n2) {
            stringBuilder.append(" <= ");
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }
}

