/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.CategoryNode;
import org.languagetool.gui.CheckBoxTreeCellRenderer;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.RuleNode;
import org.languagetool.gui.SavablePanel;
import org.languagetool.gui.Tools;
import org.languagetool.gui.TreeListener;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.Rule;

public class ConfigurationDialog
implements ActionListener {
    private static final String NO_SELECTED_LANGUAGE = "---";
    private static final String ACTION_COMMAND_OK = "OK";
    private static final String ACTION_COMMAND_CANCEL = "CANCEL";
    private static final int MAX_PORT = 65536;
    private static final int SHIFT1 = 4;
    private static final int SHIFT2 = 20;
    private static final int SHIFT3 = 44;
    private final ResourceBundle messages;
    private final Configuration original;
    private final Configuration config;
    private final Frame owner;
    private final boolean insideOffice;
    private final Image ltImage;
    private String dialogTitle;
    private boolean configChanged = false;
    private boolean profileChanged = true;
    private boolean restartShow = false;
    private boolean firstSelection = true;
    private JDialog dialog;
    private JCheckBox serverCheckbox;
    private JTextField serverPortField;
    private JTree[] configTree;
    private DefaultMutableTreeNode[] rootNode;
    private JCheckBox serverSettingsCheckbox;
    private JPanel disabledRulesPanel;
    private JPanel enabledRulesPanel;
    private final List<JPanel> extraPanels = new ArrayList<JPanel>();
    private final List<Rule> configurableRules = new ArrayList<Rule>();
    private String category;
    private Rule rule;

    public ConfigurationDialog(Frame owner, boolean insideOffice, Configuration config) {
        this(owner, insideOffice, null, null, config);
    }

    public ConfigurationDialog(Frame owner, boolean insideOffice, Image ltImage, String title, Configuration config) {
        this.owner = owner;
        this.insideOffice = insideOffice;
        this.original = config;
        this.config = this.original.copy(this.original);
        this.ltImage = ltImage;
        this.dialogTitle = title;
        this.messages = JLanguageTool.getMessageBundle();
    }

    void addExtraPanel(JPanel panel) {
        this.extraPanels.add(panel);
    }

    private DefaultMutableTreeNode createTree(List<Rule> rules, boolean isStyle, String tabName, DefaultMutableTreeNode root) {
        if (root == null) {
            root = new DefaultMutableTreeNode("Rules");
        } else {
            root.removeAllChildren();
        }
        String lastRuleId = null;
        TreeMap<String, CategoryNode> parents = new TreeMap<String, CategoryNode>();
        for (Rule rule : rules) {
            if (!(tabName == null && !this.config.isSpecialTabCategory(rule.getCategory().getName()) && (isStyle && this.config.isStyleCategory(rule.getCategory().getName()) || !isStyle && !this.config.isStyleCategory(rule.getCategory().getName()))) && (tabName == null || !this.config.isInSpecialTab(rule.getCategory().getName(), tabName))) continue;
            if (!parents.containsKey(rule.getCategory().getName())) {
                boolean enabled = true;
                if (this.config.getDisabledCategoryNames() != null && this.config.getDisabledCategoryNames().contains(rule.getCategory().getName())) {
                    enabled = false;
                }
                if (rule.getCategory().isDefaultOff() && (this.config.getEnabledCategoryNames() == null || !this.config.getEnabledCategoryNames().contains(rule.getCategory().getName()))) {
                    enabled = false;
                }
                CategoryNode categoryNode = new CategoryNode(rule.getCategory(), enabled);
                root.add(categoryNode);
                parents.put(rule.getCategory().getName(), categoryNode);
            }
            if (!rule.getId().equals(lastRuleId)) {
                RuleNode ruleNode = new RuleNode(rule, this.getEnabledState(rule));
                ((DefaultMutableTreeNode)parents.get(rule.getCategory().getName())).add(ruleNode);
            }
            lastRuleId = rule.getId();
        }
        return root;
    }

    private boolean getEnabledState(Rule rule) {
        boolean ret = true;
        if (this.config.getDisabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (this.config.getDisabledCategoryNames().contains(rule.getCategory().getName())) {
            ret = false;
        }
        if ((rule.isDefaultOff() || rule.getCategory().isDefaultOff()) && !this.config.getEnabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (this.insideOffice && rule.isOfficeDefaultOff() && !this.config.getEnabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (this.insideOffice && rule.isOfficeDefaultOn() && !this.config.getDisabledRuleIds().contains(rule.getId())) {
            ret = true;
        }
        if (rule.isDefaultOff() && rule.getCategory().isDefaultOff() && this.config.getEnabledRuleIds().contains(rule.getId())) {
            this.config.getDisabledCategoryNames().remove(rule.getCategory().getName());
        }
        return ret;
    }

    public boolean show(List<Rule> rules) {
        this.restartShow = false;
        do {
            this.showPanel(rules);
        } while (this.restartShow);
        return this.configChanged;
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    public boolean showPanel(List<Rule> rules) {
        GridBagConstraints cons;
        this.configChanged = false;
        if (this.original != null && !this.restartShow) {
            this.config.restoreState(this.original);
        }
        this.restartShow = false;
        this.dialog = new JDialog(this.owner, true);
        if (this.dialogTitle == null) {
            this.dialogTitle = this.messages.getString("guiConfigWindowTitle");
        }
        this.dialog.setTitle(this.dialogTitle);
        if (this.ltImage != null) {
            ((Frame)this.dialog.getOwner()).setIconImage(this.ltImage);
        }
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = actionEvent -> this.dialog.setVisible(false);
        JRootPane rootPane = this.dialog.getRootPane();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        this.configurableRules.clear();
        Language lang = this.config.getLanguage();
        if (lang == null) {
            lang = Languages.getLanguageForLocale((Locale)Locale.getDefault());
        }
        String[] specialTabNames = this.config.getSpecialTabNames();
        int numConfigTrees = 2 + specialTabNames.length;
        this.configTree = new JTree[numConfigTrees];
        this.rootNode = new DefaultMutableTreeNode[numConfigTrees];
        JPanel[] checkBoxPanel = new JPanel[numConfigTrees];
        for (int i = 0; i < numConfigTrees; ++i) {
            checkBoxPanel[i] = new JPanel();
            cons = new GridBagConstraints();
            checkBoxPanel[i].setLayout(new GridBagLayout());
            cons.anchor = 18;
            cons.gridx = 0;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.fill = 2;
            Collections.sort(rules, new CategoryComparator());
            this.rootNode[i] = i == 0 ? this.createTree(rules, false, null, null) : (i == 1 ? this.createTree(rules, true, null, null) : this.createTree(rules, true, specialTabNames[i - 2], null));
            this.configTree[i] = new JTree(this.getTreeModel(this.rootNode[i], rules));
            this.configTree[i].applyComponentOrientation(ComponentOrientation.getOrientation(lang.getLocale()));
            this.configTree[i].setRootVisible(false);
            this.configTree[i].setEditable(false);
            this.configTree[i].setCellRenderer(new CheckBoxTreeCellRenderer());
            TreeListener.install(this.configTree[i]);
            checkBoxPanel[i].add((Component)this.configTree[i], cons);
            this.configTree[i].addMouseListener(this.getMouseAdapter());
        }
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.fill = 0;
        cons.weightx = 0.0;
        if (!this.insideOffice) {
            this.createNonOfficeElements(cons, portPanel);
        } else {
            this.createOfficeElements(cons, portPanel);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton okButton = new JButton(Tools.getLabel(this.messages.getString("guiOKButton")));
        okButton.setMnemonic(Tools.getMnemonic(this.messages.getString("guiOKButton")));
        okButton.setActionCommand(ACTION_COMMAND_OK);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(Tools.getLabel(this.messages.getString("guiCancelButton")));
        cancelButton.setMnemonic(Tools.getMnemonic(this.messages.getString("guiCancelButton")));
        cancelButton.setActionCommand(ACTION_COMMAND_CANCEL);
        cancelButton.addActionListener(this);
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        buttonPanel.add((Component)okButton, cons);
        buttonPanel.add((Component)cancelButton, cons);
        JTabbedPane tabpane = new JTabbedPane();
        JPanel jProfilePane = new JPanel();
        jProfilePane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        cons.anchor = 18;
        jProfilePane.add((Component)new JScrollPane(this.getProfilePanel(rules)), cons);
        cons.weighty = 1.0;
        ++cons.gridy;
        cons.insets = new Insets(16, 4, 0, 8);
        jProfilePane.add((Component)new JLabel(this.addColonToMessageString("guiDisabledDefaultRules")), cons);
        cons.insets = new Insets(8, 4, 0, 8);
        ++cons.gridy;
        cons.weighty = 3.0;
        this.disabledRulesPanel = this.getChangedRulesPanel(rules, false, null);
        jProfilePane.add((Component)new JScrollPane(this.disabledRulesPanel), cons);
        ++cons.gridy;
        cons.insets = new Insets(16, 4, 0, 8);
        cons.weighty = 1.0;
        jProfilePane.add((Component)new JLabel(this.addColonToMessageString("guiEnabledOptionalRules")), cons);
        cons.insets = new Insets(8, 4, 0, 8);
        ++cons.gridy;
        cons.weighty = 5.0;
        this.enabledRulesPanel = this.getChangedRulesPanel(rules, true, null);
        jProfilePane.add((Component)new JScrollPane(this.enabledRulesPanel), cons);
        jProfilePane.setName(this.messages.getString("guiProfiles"));
        JPanel jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 18;
        if (!this.insideOffice) {
            ++cons.gridy;
            cons.anchor = 17;
            jPane.add((Component)this.getMotherTonguePanel(cons), cons);
            cons.gridx = 0;
            ++cons.gridy;
            jPane.add((Component)this.getNgramPanel(), cons);
        }
        ++cons.gridy;
        cons.anchor = 17;
        jPane.add((Component)portPanel, cons);
        cons.fill = 2;
        cons.anchor = 17;
        for (JPanel extra : this.extraPanels) {
            SwingUtilities.updateComponentTreeUI(extra);
            ++cons.gridy;
            jPane.add((Component)extra, cons);
        }
        ++cons.gridy;
        cons.fill = 1;
        cons.weighty = 1.0;
        jPane.add((Component)new JPanel(), cons);
        tabpane.addTab(this.messages.getString("guiGeneral"), new JScrollPane(jPane));
        jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        jPane.add((Component)new JScrollPane(checkBoxPanel[0]), cons);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 22;
        jPane.add((Component)this.getTreeButtonPanel(0), cons);
        cons.fill = 2;
        cons.anchor = 17;
        cons.gridx = 0;
        ++cons.gridy;
        jPane.add((Component)this.getRuleOptionsPanel(0), cons);
        tabpane.addTab(this.messages.getString("guiGrammarRules"), jPane);
        jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        jPane.add((Component)new JScrollPane(checkBoxPanel[1]), cons);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 22;
        jPane.add((Component)this.getTreeButtonPanel(1), cons);
        cons.fill = 2;
        cons.anchor = 17;
        cons.gridx = 0;
        ++cons.gridy;
        jPane.add((Component)this.getRuleOptionsPanel(1), cons);
        tabpane.addTab(this.messages.getString("guiStyleRules"), jPane);
        for (int i = 0; i < specialTabNames.length; ++i) {
            jPane = new JPanel();
            jPane.setLayout(new GridBagLayout());
            cons = new GridBagConstraints();
            cons.insets = new Insets(4, 4, 4, 4);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 10.0;
            cons.weighty = 10.0;
            cons.fill = 1;
            jPane.add((Component)new JScrollPane(checkBoxPanel[i + 2]), cons);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.gridx = 0;
            ++cons.gridy;
            cons.fill = 0;
            cons.anchor = 22;
            jPane.add((Component)this.getTreeButtonPanel(i + 2), cons);
            cons.fill = 2;
            cons.anchor = 17;
            cons.gridx = 0;
            ++cons.gridy;
            jPane.add((Component)this.getRuleOptionsPanel(i + 2), cons);
            tabpane.addTab(specialTabNames[i], jPane);
        }
        if (this.insideOffice) {
            String label = this.messages.getString("guiTechnicalSettings");
            if (label.endsWith(":")) {
                label = label.substring(0, label.length() - 1);
            }
            tabpane.add(label, new JScrollPane(this.getOfficeTechnicalElements()));
        }
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        cons.anchor = 18;
        contentPane.add((Component)tabpane, cons);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 13;
        contentPane.add((Component)buttonPanel, cons);
        this.dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.dialog.getSize();
        this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
        this.dialog.setLocationByPlatform(true);
        tabpane.add((Component)jProfilePane, 0);
        tabpane.setSelectedIndex(0);
        for (JPanel extra : this.extraPanels) {
            if (!(extra instanceof SavablePanel)) continue;
            ((SavablePanel)((Object)extra)).componentShowing();
        }
        this.dialog.setAutoRequestFocus(true);
        if (this.insideOffice) {
            this.dialog.setAlwaysOnTop(true);
        }
        this.dialog.setVisible(true);
        this.dialog.toFront();
        return this.configChanged;
    }

    private void createNonOfficeElements(GridBagConstraints cons, JPanel portPanel) {
        this.serverCheckbox = new JCheckBox(Tools.getLabel(this.messages.getString("guiRunOnPort")));
        this.serverCheckbox.setMnemonic(Tools.getMnemonic(this.messages.getString("guiRunOnPort")));
        this.serverCheckbox.setSelected(this.config.getRunServer());
        portPanel.add((Component)this.serverCheckbox, cons);
        this.serverCheckbox.addActionListener(e -> {
            this.serverPortField.setEnabled(this.serverCheckbox.isSelected());
            this.serverSettingsCheckbox.setEnabled(this.serverCheckbox.isSelected());
        });
        this.serverCheckbox.addItemListener(e -> this.config.setRunServer(this.serverCheckbox.isSelected()));
        this.serverPortField = new JTextField(Integer.toString(this.config.getServerPort()));
        this.serverPortField.setEnabled(this.serverCheckbox.isSelected());
        this.serverSettingsCheckbox = new JCheckBox(Tools.getLabel(this.messages.getString("useGUIConfig")));
        this.serverPortField.setMinimumSize(new Dimension(100, 25));
        cons.gridx = 1;
        portPanel.add((Component)this.serverPortField, cons);
        this.serverPortField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    int serverPort = Integer.parseInt(ConfigurationDialog.this.serverPortField.getText());
                    if (serverPort > -1 && serverPort < 65536) {
                        ConfigurationDialog.this.serverPortField.setForeground(null);
                        ConfigurationDialog.this.config.setServerPort(serverPort);
                    } else {
                        ConfigurationDialog.this.serverPortField.setForeground(Color.RED);
                    }
                }
                catch (NumberFormatException ex) {
                    ConfigurationDialog.this.serverPortField.setForeground(Color.RED);
                }
            }
        });
        cons.gridx = 0;
        cons.gridy = 10;
        this.serverSettingsCheckbox.setMnemonic(Tools.getMnemonic(this.messages.getString("useGUIConfig")));
        this.serverSettingsCheckbox.setSelected(this.config.getUseGUIConfig());
        this.serverSettingsCheckbox.setEnabled(this.config.getRunServer());
        this.serverSettingsCheckbox.addItemListener(e -> this.config.setUseGUIConfig(this.serverSettingsCheckbox.isSelected()));
        portPanel.add((Component)this.serverSettingsCheckbox, cons);
    }

    private void addOfficeLanguageElements(GridBagConstraints cons, JPanel portPanel) {
        JPanel languagePanel = new JPanel();
        languagePanel.setLayout(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.insets = new Insets(0, 0, 0, 0);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.anchor = 17;
        cons1.fill = 0;
        cons1.weightx = 0.0;
        JRadioButton[] radioButtons = new JRadioButton[2];
        ButtonGroup numParaGroup = new ButtonGroup();
        radioButtons[0] = new JRadioButton(Tools.getLabel(this.messages.getString("guiUseDocumentLanguage")));
        radioButtons[0].setActionCommand("DocLang");
        radioButtons[0].setSelected(true);
        radioButtons[1] = new JRadioButton(Tools.getLabel(this.messages.getString("guiSetLanguageTo")));
        radioButtons[1].setActionCommand("SelectLang");
        JComboBox<String> fixedLanguageBox = new JComboBox<String>(this.getPossibleLanguages(false));
        if (this.config.getFixedLanguage() != null) {
            fixedLanguageBox.setSelectedItem(this.config.getFixedLanguage().getTranslatedName(this.messages));
        }
        fixedLanguageBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Language fixedLanguage = fixedLanguageBox.getSelectedItem() instanceof String ? this.getLanguageForLocalizedName(fixedLanguageBox.getSelectedItem().toString()) : (Language)fixedLanguageBox.getSelectedItem();
                this.config.setFixedLanguage(fixedLanguage);
                this.config.setUseDocLanguage(false);
                radioButtons[1].setSelected(true);
            }
        });
        for (int i = 0; i < 2; ++i) {
            numParaGroup.add(radioButtons[i]);
        }
        if (this.config.getUseDocLanguage()) {
            radioButtons[0].setSelected(true);
        } else {
            radioButtons[1].setSelected(true);
        }
        radioButtons[0].addActionListener(e -> this.config.setUseDocLanguage(true));
        radioButtons[1].addActionListener(e -> {
            this.config.setUseDocLanguage(false);
            Language fixedLanguage = fixedLanguageBox.getSelectedItem() instanceof String ? this.getLanguageForLocalizedName(fixedLanguageBox.getSelectedItem().toString()) : (Language)fixedLanguageBox.getSelectedItem();
            this.config.setFixedLanguage(fixedLanguage);
        });
        languagePanel.add((Component)radioButtons[0], cons1);
        ++cons1.gridy;
        languagePanel.add((Component)radioButtons[1], cons1);
        cons1.gridx = 1;
        languagePanel.add(fixedLanguageBox, cons1);
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)languagePanel, cons);
    }

    private void addOfficeTextruleElements(GridBagConstraints cons, JPanel portPanel) {
        int numParaCheck = this.config.getNumParasToCheck();
        boolean useTextLevelQueue = this.config.useTextLevelQueue();
        JRadioButton[] radioButtons = new JRadioButton[3];
        ButtonGroup numParaGroup = new ButtonGroup();
        radioButtons[0] = new JRadioButton(Tools.getLabel(this.messages.getString("guiTextCheckMode")));
        radioButtons[0].setActionCommand("FullTextCheck");
        radioButtons[1] = new JRadioButton(Tools.getLabel(this.messages.getString("guiParagraphCheckMode")));
        radioButtons[1].setActionCommand("ParagraphCheck");
        radioButtons[2] = new JRadioButton(Tools.getLabel(this.messages.getString("guiDeveloperModeCheck")));
        radioButtons[2].setActionCommand("NParagraphCheck");
        final JTextField numParaField = new JTextField(Integer.toString(5), 2);
        numParaField.setEnabled(radioButtons[2].isSelected());
        numParaField.setMinimumSize(new Dimension(30, 25));
        for (int i = 0; i < 3; ++i) {
            numParaGroup.add(radioButtons[i]);
        }
        if (numParaCheck == 0 || this.config.onlySingleParagraphMode()) {
            radioButtons[1].setSelected(true);
            numParaField.setEnabled(false);
            this.config.setUseTextLevelQueue(false);
            if (this.config.onlySingleParagraphMode()) {
                radioButtons[0].setEnabled(false);
                radioButtons[2].setEnabled(false);
            }
        } else if (useTextLevelQueue) {
            radioButtons[0].setSelected(true);
            numParaField.setEnabled(false);
            this.config.setNumParasToCheck(-2);
        } else {
            radioButtons[2].setSelected(true);
            numParaField.setText(Integer.toString(numParaCheck));
            numParaField.setEnabled(true);
        }
        radioButtons[0].addActionListener(e -> {
            numParaField.setEnabled(false);
            this.config.setNumParasToCheck(-2);
            this.config.setUseTextLevelQueue(true);
        });
        radioButtons[1].addActionListener(e -> {
            numParaField.setEnabled(false);
            this.config.setNumParasToCheck(0);
            this.config.setUseTextLevelQueue(false);
        });
        radioButtons[2].addActionListener(e -> {
            int numParaCheck1 = Integer.parseInt(numParaField.getText());
            if (numParaCheck1 < -2) {
                numParaCheck1 = -2;
            } else if (numParaCheck1 > 99) {
                numParaCheck1 = 99;
            }
            this.config.setNumParasToCheck(numParaCheck1);
            numParaField.setForeground(Color.BLACK);
            numParaField.setText(Integer.toString(numParaCheck1));
            numParaField.setEnabled(true);
            this.config.setUseTextLevelQueue(false);
        });
        numParaField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    int numParaCheck = Integer.parseInt(numParaField.getText());
                    if (numParaCheck > -3 && numParaCheck < 99) {
                        numParaField.setForeground(Color.BLACK);
                        ConfigurationDialog.this.config.setNumParasToCheck(numParaCheck);
                    } else {
                        numParaField.setForeground(Color.RED);
                    }
                }
                catch (NumberFormatException ex) {
                    numParaField.setForeground(Color.RED);
                }
            }
        });
        JLabel textChangedLabel = new JLabel(Tools.getLabel(this.messages.getString("guiSentenceExceedingRules")));
        ++cons.gridy;
        portPanel.add((Component)textChangedLabel, cons);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.insets = new Insets(0, 0, 0, 0);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.anchor = 17;
        cons1.fill = 0;
        cons1.weightx = 0.0;
        for (int i = 0; i < 3; ++i) {
            radioPanel.add((Component)radioButtons[i], cons1);
            if (i >= 2) continue;
            ++cons1.gridy;
        }
        cons1.gridx = 1;
        radioPanel.add((Component)numParaField, cons1);
        cons.insets = new Insets(0, 20, 0, 0);
        ++cons.gridy;
        portPanel.add((Component)radioPanel, cons);
    }

    private JPanel getOfficeTechnicalElements() {
        int i;
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.fill = 0;
        cons.weightx = 0.0;
        JCheckBox saveCacheBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiSaveCacheToFile")));
        final JTextField otherServerNameField = new JTextField(this.config.getServerUrl() == null ? "" : this.config.getServerUrl(), 25);
        otherServerNameField.setMinimumSize(new Dimension(100, 25));
        otherServerNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String serverName = otherServerNameField.getText();
                if ((serverName = serverName.trim()).isEmpty()) {
                    serverName = null;
                }
                if (ConfigurationDialog.this.config.isValidServerUrl(serverName)) {
                    otherServerNameField.setForeground(Color.BLACK);
                    ConfigurationDialog.this.config.setOtherServerUrl(serverName);
                } else {
                    otherServerNameField.setForeground(Color.RED);
                }
            }
        });
        JCheckBox useServerBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiUseServer")) + " ");
        useServerBox.setSelected(this.config.useOtherServer());
        useServerBox.addItemListener(e -> {
            int select = 0;
            boolean selected = useServerBox.isSelected();
            if (selected && this.firstSelection) {
                select = this.showRemoteServerHint(useServerBox, true);
                this.firstSelection = false;
            } else {
                this.firstSelection = true;
            }
            if (select == 0) {
                useServerBox.setSelected(selected);
                this.config.setUseOtherServer(useServerBox.isSelected());
                otherServerNameField.setEnabled(useServerBox.isSelected());
            } else {
                useServerBox.setSelected(false);
                this.firstSelection = true;
            }
        });
        JLabel usernameLabel = new JLabel(Tools.getLabel(this.messages.getString("guiPremiumUsername")));
        final JTextField usernameField = new JTextField(this.config.getRemoteUsername() == null ? "" : this.config.getRemoteUsername(), 25);
        usernameField.setMinimumSize(new Dimension(100, 25));
        usernameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String username = usernameField.getText();
                if ((username = username.trim()).isEmpty()) {
                    username = null;
                }
                if (username != null) {
                    ConfigurationDialog.this.config.setRemoteUsername(username);
                }
            }
        });
        JLabel apiKeyLabel = new JLabel(Tools.getLabel(this.messages.getString("guiPremiumApiKey")));
        final JTextField apiKeyField = new JTextField(this.config.getRemoteApiKey() == null ? "" : this.config.getRemoteApiKey(), 25);
        apiKeyField.setMinimumSize(new Dimension(100, 25));
        apiKeyField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String apiKey = apiKeyField.getText();
                if ((apiKey = apiKey.trim()).isEmpty()) {
                    apiKey = null;
                }
                if (apiKey != null) {
                    ConfigurationDialog.this.config.setRemoteApiKey(apiKey);
                }
            }
        });
        JCheckBox isPremiumBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiUsePremiumAccount")) + " ");
        isPremiumBox.setSelected(this.config.isPremium());
        isPremiumBox.addItemListener(e -> {
            boolean selected = isPremiumBox.isSelected();
            this.config.setPremium(selected);
            usernameLabel.setEnabled(selected);
            usernameField.setEnabled(selected);
            apiKeyLabel.setEnabled(selected);
            apiKeyField.setEnabled(selected);
        });
        JRadioButton[] typeOfCheckButtons = new JRadioButton[3];
        ButtonGroup typeOfCheckGroup = new ButtonGroup();
        typeOfCheckButtons[0] = new JRadioButton(Tools.getLabel(this.messages.getString("guiOneThread")));
        typeOfCheckButtons[0].addActionListener(e -> {
            otherServerNameField.setEnabled(false);
            useServerBox.setEnabled(false);
            usernameLabel.setEnabled(false);
            usernameField.setEnabled(false);
            apiKeyLabel.setEnabled(false);
            apiKeyField.setEnabled(false);
            isPremiumBox.setEnabled(false);
            this.config.setMultiThreadLO(false);
            this.config.setRemoteCheck(false);
        });
        typeOfCheckButtons[1] = new JRadioButton(Tools.getLabel(this.messages.getString("guiIsMultiThread")));
        typeOfCheckButtons[1].addActionListener(e -> {
            otherServerNameField.setEnabled(false);
            useServerBox.setEnabled(false);
            usernameLabel.setEnabled(false);
            usernameField.setEnabled(false);
            apiKeyLabel.setEnabled(false);
            apiKeyField.setEnabled(false);
            isPremiumBox.setEnabled(false);
            this.config.setMultiThreadLO(true);
            this.config.setRemoteCheck(false);
        });
        typeOfCheckButtons[2] = new JRadioButton(Tools.getLabel(this.messages.getString("guiUseRemoteServer")));
        typeOfCheckButtons[2].addActionListener(e -> {
            int select = 0;
            boolean selected = typeOfCheckButtons[2].isSelected();
            if (selected && this.firstSelection) {
                select = this.showRemoteServerHint(typeOfCheckButtons[2], false);
                this.firstSelection = false;
            } else {
                this.firstSelection = true;
            }
            if (select == 0) {
                otherServerNameField.setEnabled(useServerBox.isSelected());
                useServerBox.setEnabled(true);
                usernameLabel.setEnabled(isPremiumBox.isSelected());
                usernameField.setEnabled(isPremiumBox.isSelected());
                apiKeyLabel.setEnabled(isPremiumBox.isSelected());
                apiKeyField.setEnabled(isPremiumBox.isSelected());
                isPremiumBox.setEnabled(true);
                this.config.setMultiThreadLO(false);
                this.config.setRemoteCheck(true);
            } else {
                if (this.config.isMultiThread()) {
                    typeOfCheckButtons[1].setSelected(true);
                } else {
                    typeOfCheckButtons[0].setSelected(true);
                }
                this.firstSelection = true;
            }
        });
        for (i = 0; i < 3; ++i) {
            typeOfCheckGroup.add(typeOfCheckButtons[i]);
        }
        if (this.config.doRemoteCheck()) {
            typeOfCheckButtons[2].setSelected(true);
            otherServerNameField.setEnabled(useServerBox.isSelected());
            useServerBox.setEnabled(true);
            usernameLabel.setEnabled(isPremiumBox.isSelected());
            usernameField.setEnabled(isPremiumBox.isSelected());
            apiKeyLabel.setEnabled(isPremiumBox.isSelected());
            apiKeyField.setEnabled(isPremiumBox.isSelected());
            isPremiumBox.setEnabled(true);
            this.config.setMultiThreadLO(false);
            this.config.setRemoteCheck(true);
        } else if (this.config.isMultiThread()) {
            typeOfCheckButtons[1].setSelected(true);
            otherServerNameField.setEnabled(false);
            useServerBox.setEnabled(false);
            usernameLabel.setEnabled(false);
            usernameField.setEnabled(false);
            apiKeyLabel.setEnabled(false);
            apiKeyField.setEnabled(false);
            isPremiumBox.setEnabled(false);
            this.config.setMultiThreadLO(true);
            this.config.setRemoteCheck(false);
        } else {
            typeOfCheckButtons[0].setSelected(true);
            otherServerNameField.setEnabled(false);
            useServerBox.setEnabled(false);
            usernameLabel.setEnabled(false);
            usernameField.setEnabled(false);
            apiKeyLabel.setEnabled(false);
            apiKeyField.setEnabled(false);
            isPremiumBox.setEnabled(false);
            this.config.setMultiThreadLO(false);
            this.config.setRemoteCheck(false);
        }
        ++cons.gridy;
        cons.insets = new Insets(0, 20, 0, 0);
        for (i = 0; i < 3; ++i) {
            portPanel.add((Component)typeOfCheckButtons[i], cons);
            if (i >= 3) continue;
            ++cons.gridy;
        }
        JPanel serverPanel = new JPanel();
        serverPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.insets = new Insets(0, 20, 0, 0);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.anchor = 17;
        cons1.fill = 0;
        cons1.weightx = 0.0;
        serverPanel.add((Component)useServerBox, cons1);
        ++cons1.gridx;
        serverPanel.add((Component)otherServerNameField, cons1);
        JLabel serverExampleLabel = new JLabel(" " + Tools.getLabel(this.messages.getString("guiUseServerExample")));
        serverExampleLabel.setEnabled(false);
        ++cons1.gridy;
        serverPanel.add((Component)serverExampleLabel, cons1);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)serverPanel, cons);
        JPanel premiumPanel = new JPanel();
        premiumPanel.setLayout(new GridBagLayout());
        cons1 = new GridBagConstraints();
        cons1.insets = new Insets(0, 20, 0, 0);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.anchor = 17;
        cons1.fill = 0;
        cons1.weightx = 0.0;
        premiumPanel.add((Component)isPremiumBox, cons1);
        cons1.insets = new Insets(0, 44, 0, 0);
        ++cons1.gridy;
        premiumPanel.add((Component)usernameLabel, cons1);
        ++cons1.gridy;
        premiumPanel.add((Component)usernameField, cons1);
        ++cons1.gridy;
        premiumPanel.add((Component)apiKeyLabel, cons1);
        ++cons1.gridy;
        premiumPanel.add((Component)apiKeyField, cons1);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)premiumPanel, cons);
        saveCacheBox.setSelected(this.config.saveLoCache());
        saveCacheBox.addItemListener(e1 -> this.config.setSaveLoCache(saveCacheBox.isSelected()));
        cons.insets = new Insets(0, 20, 0, 0);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)saveCacheBox, cons);
        ++cons.gridy;
        portPanel.add((Component)this.getNgramPanel(), cons);
        return portPanel;
    }

    private void createOfficeElements(GridBagConstraints cons, JPanel portPanel) {
        this.addOfficeLanguageElements(cons, portPanel);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)new JLabel(" "), cons);
        ++cons.gridy;
        portPanel.add((Component)this.getMotherTonguePanel(cons), cons);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)new JLabel(" "), cons);
        JCheckBox useLtSpellCheckerBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiUseLtSpellChecker")));
        useLtSpellCheckerBox.setSelected(this.config.useLtSpellChecker());
        useLtSpellCheckerBox.addItemListener(e -> this.config.setUseLtSpellChecker(useLtSpellCheckerBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)useLtSpellCheckerBox, cons);
        JCheckBox markSingleCharBold = new JCheckBox(Tools.getLabel(this.messages.getString("guiMarkSingleCharBold")));
        markSingleCharBold.setSelected(this.config.markSingleCharBold());
        markSingleCharBold.addItemListener(e -> this.config.setMarkSingleCharBold(markSingleCharBold.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)markSingleCharBold, cons);
        JCheckBox noSynonymsAsSuggestionsBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiNoSynonymsAsSuggestions")));
        noSynonymsAsSuggestionsBox.setSelected(this.config.noSynonymsAsSuggestions());
        noSynonymsAsSuggestionsBox.addItemListener(e -> this.config.setNoSynonymsAsSuggestions(noSynonymsAsSuggestionsBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)noSynonymsAsSuggestionsBox, cons);
        JCheckBox includeTrackedChangesBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiIncludeTrackedChanges")));
        includeTrackedChangesBox.setSelected(this.config.includeTrackedChanges());
        includeTrackedChangesBox.addItemListener(e -> this.config.setIncludeTrackedChanges(includeTrackedChangesBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)includeTrackedChangesBox, cons);
        JCheckBox enableTmpOffRulesBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiActivateTempOffRules")));
        enableTmpOffRulesBox.setSelected(this.config.enableTmpOffRules());
        enableTmpOffRulesBox.addItemListener(e -> this.config.setEnableTmpOffRules(enableTmpOffRulesBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)enableTmpOffRulesBox, cons);
        JCheckBox enableGoalSpecificRulesBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiEnableGoalSpecificRules")));
        enableGoalSpecificRulesBox.setSelected(this.config.enableGoalSpecificRules());
        enableGoalSpecificRulesBox.addItemListener(e -> this.config.setEnableGoalSpecificRules(enableGoalSpecificRulesBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)enableGoalSpecificRulesBox, cons);
        JCheckBox noBackgroundCheckBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiNoBackgroundCheck")));
        noBackgroundCheckBox.setSelected(this.config.noBackgroundCheck());
        noBackgroundCheckBox.addItemListener(e -> this.config.setNoBackgroundCheck(noBackgroundCheckBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)noBackgroundCheckBox, cons);
        ++cons.gridy;
        portPanel.add((Component)new JLabel(" "), cons);
        this.addOfficeTextruleElements(cons, portPanel);
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)new JLabel(" "), cons);
    }

    private int showRemoteServerHint(Component component, boolean otherServer) {
        if (this.config.useOtherServer() || otherServer) {
            return JOptionPane.showConfirmDialog(component, MessageFormat.format(this.messages.getString("loRemoteInfoOtherServer"), this.config.getServerUrl()), this.messages.getString("loMenuRemoteInfo"), 2);
        }
        return JOptionPane.showConfirmDialog(component, this.messages.getString("loRemoteInfoDefaultServer"), this.messages.getString("loMenuRemoteInfo"), 2);
    }

    @NotNull
    private DefaultTreeModel getTreeModel(DefaultMutableTreeNode rootNode, final List<Rule> rules) {
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DefaultMutableTreeNode o;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                int index = e.getChildIndices()[0];
                if ((node = (DefaultMutableTreeNode)node.getChildAt(index)) instanceof RuleNode) {
                    o = (RuleNode)node;
                    if (((RuleNode)o).getRule().isDefaultOff() || ((RuleNode)o).getRule().getCategory().isDefaultOff()) {
                        if (((RuleNode)o).isEnabled()) {
                            ConfigurationDialog.this.config.getEnabledRuleIds().add(((RuleNode)o).getRule().getId());
                            ConfigurationDialog.this.config.getDisabledRuleIds().remove(((RuleNode)o).getRule().getId());
                        } else {
                            ConfigurationDialog.this.config.getEnabledRuleIds().remove(((RuleNode)o).getRule().getId());
                            ConfigurationDialog.this.config.getDisabledRuleIds().add(((RuleNode)o).getRule().getId());
                        }
                    } else if (((RuleNode)o).isEnabled()) {
                        ConfigurationDialog.this.config.getDisabledRuleIds().remove(((RuleNode)o).getRule().getId());
                    } else {
                        ConfigurationDialog.this.config.getDisabledRuleIds().add(((RuleNode)o).getRule().getId());
                    }
                    ConfigurationDialog.this.updateProfileRules(rules);
                }
                if (node instanceof CategoryNode) {
                    o = (CategoryNode)node;
                    if (((CategoryNode)o).getCategory().isDefaultOff()) {
                        if (((CategoryNode)o).isEnabled()) {
                            ConfigurationDialog.this.config.getDisabledCategoryNames().remove(((CategoryNode)o).getCategory().getName());
                            ConfigurationDialog.this.config.getEnabledCategoryNames().add(((CategoryNode)o).getCategory().getName());
                        } else {
                            ConfigurationDialog.this.config.getDisabledCategoryNames().add(((CategoryNode)o).getCategory().getName());
                            ConfigurationDialog.this.config.getEnabledCategoryNames().remove(((CategoryNode)o).getCategory().getName());
                        }
                    } else if (((CategoryNode)o).isEnabled()) {
                        ConfigurationDialog.this.config.getDisabledCategoryNames().remove(((CategoryNode)o).getCategory().getName());
                    } else {
                        ConfigurationDialog.this.config.getDisabledCategoryNames().add(((CategoryNode)o).getCategory().getName());
                    }
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        return treeModel;
    }

    @NotNull
    private MouseAdapter getMouseAdapter() {
        return new MouseAdapter(){

            private void handlePopupEvent(MouseEvent e) {
                JTree tree = (JTree)e.getSource();
                TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                TreePath[] paths = tree.getSelectionPaths();
                boolean isSelected = false;
                if (paths != null) {
                    for (TreePath selectionPath : paths) {
                        if (!selectionPath.equals(path)) continue;
                        isSelected = true;
                    }
                }
                if (!isSelected) {
                    tree.setSelectionPath(path);
                }
                if (node.isLeaf()) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem aboutRuleMenuItem = new JMenuItem(ConfigurationDialog.this.messages.getString("guiAboutRuleMenu"));
                    aboutRuleMenuItem.addActionListener(actionEvent -> {
                        RuleNode node1 = (RuleNode)tree.getSelectionPath().getLastPathComponent();
                        Rule rule = node1.getRule();
                        Language lang = ConfigurationDialog.this.config.getLanguage();
                        if (lang == null) {
                            lang = Languages.getLanguageForLocale((Locale)Locale.getDefault());
                        }
                        Tools.showRuleInfoDialog(tree, ConfigurationDialog.this.messages.getString("guiAboutRuleTitle"), rule.getDescription(), rule, rule.getUrl(), ConfigurationDialog.this.messages, lang.getShortCodeWithCountryAndVariant());
                    });
                    popup.add(aboutRuleMenuItem);
                    popup.show(tree, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopupEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopupEvent(e);
                }
            }
        };
    }

    @NotNull
    private JPanel getTreeButtonPanel(int num) {
        JPanel treeButtonPanel = new JPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        JButton expandAllButton = new JButton(this.messages.getString("guiExpandAll"));
        treeButtonPanel.add((Component)expandAllButton, cons);
        expandAllButton.addActionListener(e -> {
            TreeNode root = (TreeNode)this.configTree[num].getModel().getRoot();
            TreePath parent = new TreePath(root);
            Enumeration<? extends TreeNode> cat = root.children();
            while (cat.hasMoreElements()) {
                TreeNode n = cat.nextElement();
                TreePath child = parent.pathByAddingChild(n);
                this.configTree[num].expandPath(child);
            }
        });
        cons.gridx = 1;
        cons.gridy = 0;
        JButton collapseAllButton = new JButton(this.messages.getString("guiCollapseAll"));
        treeButtonPanel.add((Component)collapseAllButton, cons);
        collapseAllButton.addActionListener(e -> {
            TreeNode root = (TreeNode)this.configTree[num].getModel().getRoot();
            TreePath parent = new TreePath(root);
            Enumeration<? extends TreeNode> categ = root.children();
            while (categ.hasMoreElements()) {
                TreeNode n = categ.nextElement();
                TreePath child = parent.pathByAddingChild(n);
                this.configTree[num].collapsePath(child);
            }
        });
        return treeButtonPanel;
    }

    @NotNull
    private JPanel getProfilePanel(List<Rule> rules) {
        this.profileChanged = true;
        JPanel profilePanel = new JPanel();
        profilePanel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 0, 8);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.anchor = 17;
        ArrayList<String> profiles = new ArrayList<String>();
        String defaultOptions = this.messages.getString("guiDefaultOptions");
        String userOptions = this.messages.getString("guiUserProfile");
        profiles.addAll(this.config.getDefinedProfiles());
        profiles.sort(null);
        profiles.add(0, userOptions);
        String currentProfile = this.config.getCurrentProfile();
        JComboBox<String> profileBox = new JComboBox<String>(profiles.toArray(new String[0]));
        if (currentProfile == null || currentProfile.isEmpty()) {
            profileBox.setSelectedItem(userOptions);
        } else {
            profileBox.setSelectedItem(currentProfile);
        }
        profileBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if (this.profileChanged) {
                    try {
                        this.config.saveConfiguration(null);
                        ArrayList<String> saveProfiles = new ArrayList<String>();
                        saveProfiles.addAll(this.config.getDefinedProfiles());
                        if (e.getItem().equals(userOptions)) {
                            this.config.initOptions();
                            this.config.loadConfiguration("");
                            this.config.setCurrentProfile(null);
                        } else {
                            this.config.initOptions();
                            this.config.loadConfiguration((String)e.getItem());
                            this.config.setCurrentProfile((String)e.getItem());
                        }
                        this.config.addProfiles(saveProfiles);
                        this.restartShow = true;
                        this.dialog.setVisible(false);
                    }
                    catch (IOException iOException) {}
                } else {
                    this.profileChanged = true;
                }
            }
        });
        profilePanel.add((Component)new JLabel(this.addColonToMessageString("guiCurrentProfile")), cons);
        cons.insets = new Insets(6, 16, 0, 8);
        ++cons.gridy;
        profilePanel.add(profileBox, cons);
        JButton renameButton = new JButton(this.messages.getString("guiRenameProfile") + "...");
        renameButton.setEnabled(!profileBox.getSelectedItem().equals(defaultOptions) && !profileBox.getSelectedItem().equals(userOptions));
        renameButton.addActionListener(e -> {
            boolean noName = true;
            String profileName = (String)profileBox.getSelectedItem();
            while (noName && (profileName = JOptionPane.showInputDialog(this.dialog, this.messages.getString("guiRenameProfile") + ":", profileName)) != null && !profileName.equals("")) {
                profileName = profileName.replaceAll("[ \t=]", "_");
                noName = false;
                while (this.config.getDefinedProfiles().contains(profileName) || userOptions.equals(profileName)) {
                    profileName = profileName + "_new";
                    noName = true;
                }
            }
            if (profileName != null && !profileName.equals("")) {
                this.config.removeProfile(this.config.getCurrentProfile());
                this.config.addProfile(profileName);
                this.config.setCurrentProfile(profileName);
                this.restartShow = true;
                this.dialog.setVisible(false);
            }
        });
        ++cons.gridy;
        profilePanel.add((Component)renameButton, cons);
        JButton exportButton = new JButton(this.messages.getString("guiExportProfile") + "...");
        exportButton.setEnabled(!profileBox.getSelectedItem().equals(defaultOptions) && !profileBox.getSelectedItem().equals(userOptions));
        exportButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int choose = fileChooser.showSaveDialog(this.dialog);
            if (choose == 0) {
                try {
                    this.config.exportProfile((String)profileBox.getSelectedItem(), fileChooser.getSelectedFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        ++cons.gridx;
        profilePanel.add((Component)exportButton, cons);
        JButton defaultButton = new JButton(defaultOptions);
        defaultButton.addActionListener(e -> {
            ArrayList<String> saveProfiles = new ArrayList<String>();
            saveProfiles.addAll(this.config.getDefinedProfiles());
            String saveCurrent = this.config.getCurrentProfile() == null ? null : this.config.getCurrentProfile();
            this.config.initOptions();
            this.config.addProfiles(saveProfiles);
            this.config.setCurrentProfile(saveCurrent);
            this.restartShow = true;
            this.dialog.setVisible(false);
        });
        cons.gridx = 0;
        ++cons.gridy;
        profilePanel.add((Component)defaultButton, cons);
        JButton deleteButton = new JButton(this.messages.getString("guiDeleteProfile"));
        deleteButton.setEnabled(!profileBox.getSelectedItem().equals(defaultOptions) && !profileBox.getSelectedItem().equals(userOptions));
        deleteButton.addActionListener(e -> {
            ArrayList<String> saveProfiles = new ArrayList<String>();
            saveProfiles.addAll(this.config.getDefinedProfiles());
            this.config.initOptions();
            try {
                this.config.loadConfiguration("");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.config.setCurrentProfile(null);
            this.config.addProfiles(saveProfiles);
            this.config.removeProfile((String)profileBox.getSelectedItem());
            this.restartShow = true;
            this.dialog.setVisible(false);
        });
        ++cons.gridx;
        profilePanel.add((Component)deleteButton, cons);
        cons.insets = new Insets(16, 4, 0, 8);
        cons.gridx = 0;
        ++cons.gridy;
        profilePanel.add((Component)new JLabel(this.addColonToMessageString("guiAddNewProfile")), cons);
        cons.insets = new Insets(6, 16, 0, 8);
        JButton addButton = new JButton(this.messages.getString("guiAddProfile") + "...");
        addButton.addActionListener(e -> {
            boolean noName = true;
            String profileName = "";
            while (noName && (profileName = JOptionPane.showInputDialog(this.dialog, this.messages.getString("guiAddNewProfile"), profileName)) != null && !profileName.equals("")) {
                profileName = profileName.replaceAll("[ \t=]", "_");
                noName = false;
                while (this.config.getDefinedProfiles().contains(profileName) || userOptions.equals(profileName)) {
                    profileName = profileName + "_new";
                    noName = true;
                }
            }
            if (profileName != null && !profileName.equals("")) {
                try {
                    this.config.saveConfiguration(null);
                    this.config.initOptions();
                    this.config.loadConfiguration(this.config.getCurrentProfile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.config.addProfile(profileName);
                this.config.setCurrentProfile(profileName);
                this.profileChanged = false;
                profileBox.addItem(profileName);
                profileBox.setSelectedItem(profileName);
                deleteButton.setEnabled(true);
                renameButton.setEnabled(true);
                exportButton.setEnabled(true);
            }
        });
        cons.gridx = 0;
        ++cons.gridy;
        profilePanel.add((Component)addButton, cons);
        JButton importButton = new JButton(this.messages.getString("guiImportProfile") + "...");
        importButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int choose = fileChooser.showOpenDialog(this.dialog);
            if (choose == 0) {
                try {
                    this.config.saveConfiguration(null);
                    this.config.initOptions();
                    this.config.loadConfiguration(this.config.getCurrentProfile());
                    ArrayList<String> saveProfiles = new ArrayList<String>();
                    saveProfiles.addAll(this.config.getDefinedProfiles());
                    Configuration saveConfig = this.config.copy(this.config);
                    this.config.initOptions();
                    this.config.importProfile(fileChooser.getSelectedFile());
                    String profileName = this.config.getCurrentProfile();
                    if (profileName != null) {
                        this.config.addProfiles(saveProfiles);
                        profileName = profileName.replaceAll("[ \t=]", "_");
                        while (this.config.getDefinedProfiles().contains(profileName) || userOptions.equals(profileName)) {
                            profileName = profileName + "_new";
                        }
                        this.config.setCurrentProfile(profileName);
                        this.config.addProfile(profileName);
                        this.config.saveConfiguration(null);
                    } else {
                        this.config.restoreState(saveConfig);
                    }
                    this.restartShow = true;
                    this.dialog.setVisible(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        ++cons.gridx;
        profilePanel.add((Component)importButton, cons);
        return profilePanel;
    }

    private String addColonToMessageString(String message) {
        String str = this.messages.getString(message);
        if (!str.endsWith(":")) {
            return str + ":";
        }
        return str;
    }

    @NotNull
    private JPanel getMotherTonguePanel(GridBagConstraints cons) {
        JPanel motherTonguePanel = new JPanel();
        motherTonguePanel.add((Component)new JLabel(this.messages.getString("guiMotherTongue")), cons);
        JComboBox<String> motherTongueBox = new JComboBox<String>(this.getPossibleLanguages(true));
        if (this.config.getMotherTongue() != null) {
            motherTongueBox.setSelectedItem(this.config.getMotherTongue().getTranslatedName(this.messages));
        }
        motherTongueBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Language motherTongue = motherTongueBox.getSelectedItem() instanceof String ? this.getLanguageForLocalizedName(motherTongueBox.getSelectedItem().toString()) : (Language)motherTongueBox.getSelectedItem();
                this.config.setMotherTongue(motherTongue);
            }
        });
        motherTonguePanel.add(motherTongueBox, cons);
        return motherTonguePanel;
    }

    private JPanel getNgramPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.insets = new Insets(0, 0, 0, 0);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.anchor = 17;
        cons1.fill = 0;
        cons1.weightx = 0.0;
        this.addNgramPanel(cons1, panel);
        return panel;
    }

    private void addNgramPanel(GridBagConstraints cons, JPanel panel) {
        cons.gridx = 0;
        panel.add((Component)new JLabel(this.messages.getString("guiNgramDir") + "  "), cons);
        File dir = this.config.getNgramDirectory();
        int maxDirDisplayLength = 45;
        String buttonText = dir != null ? StringUtils.abbreviate((String)dir.getAbsolutePath(), (int)maxDirDisplayLength) : this.messages.getString("guiNgramDirSelect");
        JButton ngramDirButton = new JButton(buttonText);
        ngramDirButton.addActionListener(e -> {
            File newDir = Tools.openDirectoryDialog(this.owner, dir);
            if (newDir != null) {
                try {
                    if (this.config.getLanguage() != null) {
                        File checkDir = new File(newDir, this.config.getLanguage().getShortCode());
                        LuceneLanguageModel.validateDirectory((File)checkDir);
                    }
                    this.config.setNgramDirectory(newDir);
                    ngramDirButton.setText(StringUtils.abbreviate((String)newDir.getAbsolutePath(), (int)maxDirDisplayLength));
                }
                catch (Exception ex) {
                    Tools.showErrorMessage(ex);
                }
            } else {
                this.config.setNgramDirectory(null);
                ngramDirButton.setText(StringUtils.abbreviate((String)this.messages.getString("guiNgramDirSelect"), (int)maxDirDisplayLength));
            }
        });
        ++cons.gridx;
        panel.add((Component)ngramDirButton, cons);
        JButton helpButton = new JButton(this.messages.getString("guiNgramHelp"));
        helpButton.addActionListener(e -> Tools.openURL("https://dev.languagetool.org/finding-errors-using-n-gram-data"));
        ++cons.gridx;
        panel.add((Component)helpButton, cons);
    }

    private String[] getPossibleLanguages(boolean addNoSeletion) {
        ArrayList<String> languages = new ArrayList<String>();
        if (addNoSeletion) {
            languages.add(NO_SELECTED_LANGUAGE);
        }
        for (Language lang : Languages.get()) {
            languages.add(lang.getTranslatedName(this.messages));
            languages.sort(null);
        }
        return languages.toArray(new String[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ACTION_COMMAND_OK.equals(e.getActionCommand())) {
            String serverName;
            if (this.original != null) {
                this.original.restoreState(this.config);
            }
            for (JPanel extra : this.extraPanels) {
                if (!(extra instanceof SavablePanel)) continue;
                ((SavablePanel)((Object)extra)).save();
            }
            if (this.insideOffice && this.config.doRemoteCheck() && this.config.useOtherServer() && ((serverName = this.config.getServerUrl()) == null || !serverName.startsWith("http://") && !serverName.startsWith("https://") || serverName.endsWith("/") || serverName.endsWith("/v2"))) {
                JOptionPane.showMessageDialog(this.dialog, Tools.getLabel(this.messages.getString("guiUseServerWarning1")) + "\n" + Tools.getLabel(this.messages.getString("guiUseServerWarning2")));
                if (serverName.endsWith("/")) {
                    serverName = serverName.substring(0, serverName.length() - 1);
                    this.config.setOtherServerUrl(serverName);
                }
                if (serverName.endsWith("/v2")) {
                    serverName = serverName.substring(0, serverName.length() - 3);
                    this.config.setOtherServerUrl(serverName);
                }
                this.restartShow = true;
                this.dialog.setVisible(false);
                return;
            }
            this.configChanged = true;
            this.dialog.setVisible(false);
        } else if (ACTION_COMMAND_CANCEL.equals(e.getActionCommand())) {
            this.dialog.setVisible(false);
        }
    }

    @Nullable
    private Language getLanguageForLocalizedName(String languageName) {
        for (Language element : Languages.get()) {
            if (!languageName.equals(element.getTranslatedName(this.messages))) continue;
            return element;
        }
        return null;
    }

    private void updateRulesTrees(List<Rule> rules) {
        String[] specialTabNames = this.config.getSpecialTabNames();
        int numConfigTrees = 2 + specialTabNames.length;
        for (int i = 0; i < numConfigTrees; ++i) {
            this.rootNode[i] = i == 0 ? this.createTree(rules, false, null, this.rootNode[i]) : (i == 1 ? this.createTree(rules, true, null, this.rootNode[i]) : this.createTree(rules, true, specialTabNames[i - 2], this.rootNode[i]));
            this.configTree[i].setModel(this.getTreeModel(this.rootNode[i], rules));
        }
    }

    private void updateProfileRules(List<Rule> rules) {
        this.getChangedRulesPanel(rules, false, this.disabledRulesPanel);
        this.getChangedRulesPanel(rules, true, this.enabledRulesPanel);
    }

    private JPanel getChangedRulesPanel(List<Rule> rules, boolean enabledRules, JPanel panel) {
        if (panel == null) {
            panel = new JPanel();
        } else {
            panel.removeAll();
        }
        panel.setBackground(new Color(169, 169, 169));
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.anchor = 17;
        cons.fill = 0;
        cons.insets = new Insets(4, 3, 0, 4);
        ArrayList<String> changedRuleIds = enabledRules ? new ArrayList<String>(this.config.getEnabledRuleIds()) : new ArrayList<String>(this.config.getDisabledRuleIds());
        if (changedRuleIds != null) {
            ArrayList<JCheckBox> ruleCheckboxes = new ArrayList<JCheckBox>();
            for (int i = changedRuleIds.size() - 1; i >= 0; --i) {
                String ruleId = (String)changedRuleIds.get(i);
                String ruleDescription = null;
                for (Rule rule : rules) {
                    if (!rule.getId().equals(ruleId)) continue;
                    if (enabledRules && (rule.getCategory().isDefaultOff() || rule.isDefaultOff() && !rule.isOfficeDefaultOn()) || !enabledRules && !rule.getCategory().isDefaultOff() && (!rule.isDefaultOff() || rule.isOfficeDefaultOn())) {
                        ruleDescription = rule.getDescription();
                        break;
                    }
                    if (enabledRules) {
                        this.config.removeEnabledRuleId(ruleId);
                        break;
                    }
                    this.config.removeDisabledRuleId(ruleId);
                    break;
                }
                if (ruleDescription == null) continue;
                JCheckBox ruleCheckbox = new JCheckBox(ruleDescription);
                ruleCheckbox.setName(ruleId);
                ruleCheckboxes.add(ruleCheckbox);
                ruleCheckbox.setSelected(enabledRules);
                panel.add((Component)ruleCheckbox, cons);
                ruleCheckbox.addActionListener(e -> {
                    if (ruleCheckbox.isSelected()) {
                        this.config.getEnabledRuleIds().add(ruleCheckbox.getName());
                        this.config.getDisabledRuleIds().remove(ruleCheckbox.getName());
                        this.updateRulesTrees(rules);
                    } else {
                        this.config.getEnabledRuleIds().remove(ruleCheckbox.getName());
                        this.config.getDisabledRuleIds().add(ruleCheckbox.getName());
                        this.updateRulesTrees(rules);
                    }
                });
                cons.gridx = 0;
                ++cons.gridy;
            }
        }
        return panel;
    }

    private String[] getUnderlineTypes() {
        String[] types = new String[]{this.messages.getString("guiUTypeWave"), this.messages.getString("guiUTypeBoldWave"), this.messages.getString("guiUTypeBold"), this.messages.getString("guiUTypeDash")};
        return types;
    }

    private int getUnderlineType(String category, String ruleId) {
        short nType = this.config.getUnderlineType(category, ruleId);
        if (nType == 18) {
            return 1;
        }
        if (nType == 12) {
            return 2;
        }
        if (nType == 5) {
            return 3;
        }
        return 0;
    }

    private void setUnderlineType(int index, String category, String ruleId) {
        if (ruleId == null) {
            if (index == 1) {
                this.config.setUnderlineType(category, (short)18);
            } else if (index == 2) {
                this.config.setUnderlineType(category, (short)12);
            } else if (index == 3) {
                this.config.setUnderlineType(category, (short)5);
            } else {
                this.config.setDefaultUnderlineType(category);
            }
        } else if (index == 1) {
            this.config.setUnderlineRuleType(ruleId, (short)18);
        } else if (index == 2) {
            this.config.setUnderlineRuleType(ruleId, (short)12);
        } else if (index == 3) {
            this.config.setUnderlineRuleType(ruleId, (short)5);
        } else {
            this.config.setDefaultUnderlineRuleType(ruleId);
        }
    }

    JPanel getUnderlineColorPanel(List<Rule> rules) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.fill = 0;
        cons.anchor = 18;
        ArrayList<String> categories = new ArrayList<String>();
        for (Rule rule : rules) {
            String category = rule.getCategory().getName();
            boolean contain = false;
            for (String c : categories) {
                if (!c.equals(category)) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            categories.add(category);
        }
        ArrayList<JLabel> categoryLabel = new ArrayList<JLabel>();
        ArrayList<JLabel> underlineLabel = new ArrayList<JLabel>();
        ArrayList<JButton> changeButton = new ArrayList<JButton>();
        ArrayList<JButton> defaultButton = new ArrayList<JButton>();
        ArrayList<JComboBox<String>> underlineType = new ArrayList<JComboBox<String>>();
        for (int nCat = 0; nCat < categories.size(); ++nCat) {
            categoryLabel.add(new JLabel((String)categories.get(nCat) + " "));
            underlineLabel.add(new JLabel(" \u2588\u2588\u2588 "));
            ((JLabel)underlineLabel.get(nCat)).setForeground(this.config.getUnderlineColor((String)categories.get(nCat), null));
            ((JLabel)underlineLabel.get(nCat)).setBackground(this.config.getUnderlineColor((String)categories.get(nCat), null));
            final JLabel uLabel = (JLabel)underlineLabel.get(nCat);
            final String cLabel = (String)categories.get(nCat);
            panel.add((Component)categoryLabel.get(nCat), cons);
            underlineType.add(new JComboBox<String>(this.getUnderlineTypes()));
            JComboBox uLineType = (JComboBox)underlineType.get(nCat);
            if (this.insideOffice) {
                uLineType.setSelectedIndex(this.getUnderlineType(cLabel, null));
                uLineType.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        this.setUnderlineType(uLineType.getSelectedIndex(), cLabel, null);
                    }
                });
                ++cons.gridx;
                panel.add((Component)uLineType, cons);
            }
            ++cons.gridx;
            panel.add((Component)underlineLabel.get(nCat), cons);
            changeButton.add(new JButton(this.messages.getString("guiUColorChange")));
            ((JButton)changeButton.get(nCat)).addActionListener(e -> {
                final Color oldColor = uLabel.getForeground();
                if (this.insideOffice) {
                    this.dialog.setAlwaysOnTop(false);
                }
                final JColorChooser colorChooser = new JColorChooser(oldColor);
                ActionListener okActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Color newColor = colorChooser.getColor();
                        if (newColor != null && newColor != oldColor) {
                            uLabel.setForeground(newColor);
                            ConfigurationDialog.this.config.setUnderlineColor(cLabel, newColor);
                        }
                        if (ConfigurationDialog.this.insideOffice) {
                            ConfigurationDialog.this.dialog.setAlwaysOnTop(true);
                        }
                    }
                };
                ActionListener cancelActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ConfigurationDialog.this.insideOffice) {
                            ConfigurationDialog.this.dialog.setAlwaysOnTop(true);
                        }
                    }
                };
                JDialog colorDialog = JColorChooser.createDialog(this.dialog, this.messages.getString("guiUColorDialogHeader"), true, colorChooser, okActionListener, cancelActionListener);
                if (this.insideOffice) {
                    colorDialog.setAlwaysOnTop(true);
                }
                colorDialog.toFront();
                colorDialog.setVisible(true);
            });
            ++cons.gridx;
            panel.add((Component)changeButton.get(nCat), cons);
            defaultButton.add(new JButton(this.messages.getString("guiUColorDefault")));
            ((JButton)defaultButton.get(nCat)).addActionListener(e -> {
                this.config.setDefaultUnderlineColor(cLabel);
                uLabel.setForeground(this.config.getUnderlineColor(cLabel, null));
                if (this.insideOffice) {
                    this.config.setDefaultUnderlineType(cLabel);
                    uLineType.setSelectedIndex(this.getUnderlineType(cLabel, null));
                }
            });
            ++cons.gridx;
            panel.add((Component)defaultButton.get(nCat), cons);
            cons.gridx = 0;
            ++cons.gridy;
        }
        return panel;
    }

    @NotNull
    private JPanel getRuleOptionsPanel(int num) {
        this.category = "";
        this.rule = null;
        JPanel ruleOptionsPanel = new JPanel();
        ruleOptionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons0 = new GridBagConstraints();
        cons0.gridx = 0;
        cons0.gridy = 0;
        cons0.fill = 0;
        cons0.anchor = 18;
        cons0.weightx = 2.0;
        cons0.weighty = 0.0;
        cons0.insets = new Insets(3, 8, 3, 0);
        ruleOptionsPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(null);
        colorPanel.setBounds(0, 0, 120, 10);
        colorPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.insets = new Insets(0, 0, 0, 0);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.weightx = 0.0;
        cons1.fill = 0;
        cons1.anchor = 18;
        JLabel underlineStyle = new JLabel(this.messages.getString("guiUColorStyleLabel") + " ");
        colorPanel.add(underlineStyle);
        final JLabel underlineLabel = new JLabel(" \u2588\u2588\u2588 ");
        JComboBox<String> underlineType = new JComboBox<String>(this.getUnderlineTypes());
        if (this.insideOffice) {
            underlineType.setSelectedIndex(this.getUnderlineType(this.category, this.rule == null ? null : this.rule.getId()));
            underlineType.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setUnderlineType(underlineType.getSelectedIndex(), this.category, this.rule == null ? null : this.rule.getId());
                }
            });
            ++cons1.gridx;
            colorPanel.add(underlineType);
        }
        ++cons1.gridx;
        colorPanel.add(underlineLabel);
        JButton changeButton = new JButton(this.messages.getString("guiUColorChange"));
        changeButton.addActionListener(e -> {
            final Color oldColor = underlineLabel.getForeground();
            if (this.insideOffice) {
                this.dialog.setAlwaysOnTop(false);
            }
            final JColorChooser colorChooser = new JColorChooser(oldColor);
            ActionListener okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color newColor = colorChooser.getColor();
                    if (newColor != null && newColor != oldColor) {
                        underlineLabel.setForeground(newColor);
                        if (ConfigurationDialog.this.rule == null) {
                            ConfigurationDialog.this.config.setUnderlineColor(ConfigurationDialog.this.category, newColor);
                        } else {
                            ConfigurationDialog.this.config.setUnderlineRuleColor(ConfigurationDialog.this.rule.getId(), newColor);
                        }
                    }
                    if (ConfigurationDialog.this.insideOffice) {
                        ConfigurationDialog.this.dialog.setAlwaysOnTop(true);
                    }
                }
            };
            ActionListener cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConfigurationDialog.this.insideOffice) {
                        ConfigurationDialog.this.dialog.setAlwaysOnTop(true);
                    }
                }
            };
            JDialog colorDialog = JColorChooser.createDialog(this.dialog, this.messages.getString("guiUColorDialogHeader"), true, colorChooser, okActionListener, cancelActionListener);
            if (this.insideOffice) {
                colorDialog.setAlwaysOnTop(true);
            }
            colorDialog.toFront();
            colorDialog.setVisible(true);
        });
        ++cons1.gridx;
        colorPanel.add(changeButton);
        JButton defaultButton = new JButton(this.messages.getString("guiUColorDefault"));
        defaultButton.addActionListener(e -> {
            String ruleId;
            String string = ruleId = this.rule == null ? null : this.rule.getId();
            if (this.rule == null) {
                this.config.setDefaultUnderlineColor(this.category);
            } else {
                this.config.setDefaultUnderlineRuleColor(ruleId);
            }
            underlineLabel.setForeground(this.config.getUnderlineColor(this.category, ruleId));
            if (this.insideOffice) {
                if (this.rule == null) {
                    this.config.setDefaultUnderlineType(this.category);
                } else {
                    this.config.setDefaultUnderlineRuleType(ruleId);
                }
                underlineType.setSelectedIndex(this.getUnderlineType(this.category, ruleId));
            }
        });
        ++cons1.gridx;
        colorPanel.add(defaultButton);
        colorPanel.setVisible(false);
        JPanel specialOptionPanel = new JPanel();
        specialOptionPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons2 = new GridBagConstraints();
        cons2.gridx = 0;
        cons2.gridy = 0;
        cons2.weightx = 2.0;
        cons2.anchor = 17;
        JLabel ruleLabel = new JLabel("");
        specialOptionPanel.add((Component)ruleLabel, cons2);
        ++cons2.gridx;
        final JTextField ruleValueField = new JTextField("   ", 3);
        ruleValueField.setMinimumSize(new Dimension(50, 28));
        specialOptionPanel.add((Component)ruleValueField, cons2);
        ruleValueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    if (ConfigurationDialog.this.rule != null) {
                        int num = Integer.parseInt(ruleValueField.getText());
                        if (num < ConfigurationDialog.this.rule.getMinConfigurableValue()) {
                            num = ConfigurationDialog.this.rule.getMinConfigurableValue();
                            ruleValueField.setForeground(Color.RED);
                        } else if (num > ConfigurationDialog.this.rule.getMaxConfigurableValue()) {
                            num = ConfigurationDialog.this.rule.getMaxConfigurableValue();
                            ruleValueField.setForeground(Color.RED);
                        } else {
                            ruleValueField.setForeground(null);
                        }
                        ConfigurationDialog.this.config.setConfigurableValue(ConfigurationDialog.this.rule.getId(), num);
                    }
                }
                catch (Exception ex) {
                    ruleValueField.setForeground(Color.RED);
                }
            }
        });
        specialOptionPanel.setVisible(false);
        ruleOptionsPanel.add((Component)colorPanel, cons0);
        cons0.gridx = 0;
        cons0.gridy = 1;
        ruleOptionsPanel.add((Component)specialOptionPanel, cons0);
        ruleOptionsPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.configTree[num].addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.configTree[num].getLastSelectedPathComponent();
            if (node != null) {
                if (node instanceof RuleNode) {
                    RuleNode o = (RuleNode)node;
                    this.rule = o.getRule();
                    this.category = this.rule.getCategory().getName();
                    String ruleId = this.rule.getId();
                    underlineLabel.setForeground(this.config.getUnderlineColor(this.category, ruleId));
                    underlineLabel.setBackground(this.config.getUnderlineColor(this.category, ruleId));
                    if (this.insideOffice) {
                        underlineType.setSelectedIndex(this.getUnderlineType(this.category, ruleId));
                    }
                    colorPanel.setVisible(true);
                    if (this.rule.hasConfigurableValue()) {
                        ruleLabel.setText(this.rule.getConfigureText() + " ");
                        int value = this.config.getConfigurableValue(this.rule.getId());
                        if (value < 0) {
                            value = this.rule.getDefaultValue();
                        }
                        ruleValueField.setText(Integer.toString(value));
                        specialOptionPanel.setVisible(true);
                    } else {
                        specialOptionPanel.setVisible(false);
                    }
                } else if (node instanceof CategoryNode) {
                    CategoryNode o = (CategoryNode)node;
                    this.category = o.getCategory().getName();
                    underlineLabel.setForeground(this.config.getUnderlineColor(this.category, null));
                    underlineLabel.setBackground(this.config.getUnderlineColor(this.category, null));
                    if (this.insideOffice) {
                        underlineType.setSelectedIndex(this.getUnderlineType(this.category, null));
                    }
                    colorPanel.setVisible(true);
                    specialOptionPanel.setVisible(false);
                    this.rule = null;
                }
            }
        });
        return ruleOptionsPanel;
    }

    static class CategoryComparator
    implements Comparator<Rule> {
        CategoryComparator() {
        }

        @Override
        public int compare(Rule r1, Rule r2) {
            boolean hasCat;
            boolean bl = hasCat = r1.getCategory() != null && r2.getCategory() != null;
            if (hasCat) {
                int res = r1.getCategory().getName().compareTo(r2.getCategory().getName());
                if (res == 0) {
                    return r1.getDescription() != null && r2.getDescription() != null ? r1.getDescription().compareToIgnoreCase(r2.getDescription()) : 0;
                }
                return res;
            }
            return r1.getDescription() != null && r2.getDescription() != null ? r1.getDescription().compareToIgnoreCase(r2.getDescription()) : 0;
        }
    }
}

