/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

public class ExtensionInfo {
    public static final int COMPATIBLE = 0;
    public static final int REQUIRE_SPECIFICATION_UPGRADE = 1;
    public static final int REQUIRE_IMPLEMENTATION_UPGRADE = 2;
    public static final int REQUIRE_VENDOR_SWITCH = 3;
    public static final int INCOMPATIBLE = 4;
    public String title;
    public String name;
    public String specVersion;
    public String specVendor;
    public String implementationVersion;
    public String vendor;
    public String vendorId;
    public String url;
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.misc.resources.Messages");

    public ExtensionInfo() {
    }

    public ExtensionInfo(String extensionKey, Attributes attr) throws NullPointerException {
        String s = extensionKey != null ? extensionKey + "-" : "";
        String attrKey = s + Attributes.Name.EXTENSION_NAME.toString();
        this.name = attr.getValue(attrKey);
        if (this.name != null) {
            this.name = this.name.trim();
        }
        attrKey = s + Attributes.Name.SPECIFICATION_TITLE.toString();
        this.title = attr.getValue(attrKey);
        if (this.title != null) {
            this.title = this.title.trim();
        }
        attrKey = s + Attributes.Name.SPECIFICATION_VERSION.toString();
        this.specVersion = attr.getValue(attrKey);
        if (this.specVersion != null) {
            this.specVersion = this.specVersion.trim();
        }
        attrKey = s + Attributes.Name.SPECIFICATION_VENDOR.toString();
        this.specVendor = attr.getValue(attrKey);
        if (this.specVendor != null) {
            this.specVendor = this.specVendor.trim();
        }
        attrKey = s + Attributes.Name.IMPLEMENTATION_VERSION.toString();
        this.implementationVersion = attr.getValue(attrKey);
        if (this.implementationVersion != null) {
            this.implementationVersion = this.implementationVersion.trim();
        }
        attrKey = s + Attributes.Name.IMPLEMENTATION_VENDOR.toString();
        this.vendor = attr.getValue(attrKey);
        if (this.vendor != null) {
            this.vendor = this.vendor.trim();
        }
        attrKey = s + Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString();
        this.vendorId = attr.getValue(attrKey);
        if (this.vendorId != null) {
            this.vendorId = this.vendorId.trim();
        }
        attrKey = s + Attributes.Name.IMPLEMENTATION_URL.toString();
        this.url = attr.getValue(attrKey);
        if (this.url != null) {
            this.url = this.url.trim();
        }
    }

    public int isCompatibleWith(ExtensionInfo ei) {
        if (this.name == null || ei.name == null) {
            return 4;
        }
        if (this.name.compareTo(ei.name) == 0) {
            if (this.specVersion == null || ei.specVersion == null) {
                return 0;
            }
            int version = this.compareExtensionVersion(this.specVersion, ei.specVersion);
            if (version < 0) {
                if (this.vendorId != null && ei.vendorId != null && this.vendorId.compareTo(ei.vendorId) != 0) {
                    return 3;
                }
                return 1;
            }
            if (this.vendorId != null && ei.vendorId != null) {
                if (this.vendorId.compareTo(ei.vendorId) != 0) {
                    return 3;
                }
                if (this.implementationVersion != null && ei.implementationVersion != null && (version = this.compareExtensionVersion(this.implementationVersion, ei.implementationVersion)) < 0) {
                    return 2;
                }
            }
            return 0;
        }
        return 4;
    }

    public String toString() {
        return "Extension : title(" + this.title + "), name(" + this.name + "), spec vendor(" + this.specVendor + "), spec version(" + this.specVersion + "), impl vendor(" + this.vendor + "), impl vendor id(" + this.vendorId + "), impl version(" + this.implementationVersion + "), impl url(" + this.url + ")";
    }

    private int compareExtensionVersion(String source, String target) throws NumberFormatException {
        source = source.toLowerCase();
        target = target.toLowerCase();
        return this.strictCompareExtensionVersion(source, target);
    }

    private int strictCompareExtensionVersion(String source, String target) throws NumberFormatException {
        if (source.equals(target)) {
            return 0;
        }
        StringTokenizer stk = new StringTokenizer(source, ".,");
        StringTokenizer ttk = new StringTokenizer(target, ".,");
        int n = 0;
        int m = 0;
        boolean result = false;
        if (stk.hasMoreTokens()) {
            n = this.convertToken(stk.nextToken().toString());
        }
        if (ttk.hasMoreTokens()) {
            m = this.convertToken(ttk.nextToken().toString());
        }
        if (n > m) {
            return 1;
        }
        if (m > n) {
            return -1;
        }
        int sIdx = source.indexOf(".");
        int tIdx = target.indexOf(".");
        if (sIdx == -1) {
            sIdx = source.length() - 1;
        }
        if (tIdx == -1) {
            tIdx = target.length() - 1;
        }
        return this.strictCompareExtensionVersion(source.substring(sIdx + 1), target.substring(tIdx + 1));
    }

    private int convertToken(String token) {
        int mrversion;
        int strLength;
        if (token == null || token.equals("")) {
            return 0;
        }
        int charValue = 0;
        int charVersion = 0;
        int patchVersion = 0;
        int endIndex = strLength = token.length();
        Object[] args = new Object[]{this.name};
        MessageFormat mf = new MessageFormat(rb.getString("optpkg.versionerror"));
        String versionError = mf.format(args);
        int prIndex = token.indexOf("-");
        int patchIndex = token.indexOf("_");
        if (prIndex == -1 && patchIndex == -1) {
            try {
                return Integer.parseInt(token) * 100;
            }
            catch (NumberFormatException e) {
                System.out.println(versionError);
                return 0;
            }
        }
        if (patchIndex != -1) {
            int prversion;
            try {
                prversion = Integer.parseInt(token.substring(0, patchIndex));
                char lastChar = token.charAt(strLength - 1);
                if (Character.isLetter(lastChar)) {
                    charValue = Character.getNumericValue(lastChar);
                    endIndex = strLength - 1;
                    patchVersion = Integer.parseInt(token.substring(patchIndex + 1, endIndex));
                    if (charValue >= Character.getNumericValue('a') && charValue <= Character.getNumericValue('z')) {
                        charVersion = patchVersion * 100 + charValue;
                    } else {
                        charVersion = 0;
                        System.out.println(versionError);
                    }
                } else {
                    patchVersion = Integer.parseInt(token.substring(patchIndex + 1, endIndex));
                }
            }
            catch (NumberFormatException e) {
                System.out.println(versionError);
                return 0;
            }
            return prversion * 100 + (patchVersion + charVersion);
        }
        try {
            mrversion = Integer.parseInt(token.substring(0, prIndex));
        }
        catch (NumberFormatException e) {
            System.out.println(versionError);
            return 0;
        }
        String prString = token.substring(prIndex + 1);
        String msVersion = "";
        int delta = 0;
        if (prString.indexOf("ea") != -1) {
            msVersion = prString.substring(2);
            delta = 50;
        } else if (prString.indexOf("alpha") != -1) {
            msVersion = prString.substring(5);
            delta = 40;
        } else if (prString.indexOf("beta") != -1) {
            msVersion = prString.substring(4);
            delta = 30;
        } else if (prString.indexOf("rc") != -1) {
            msVersion = prString.substring(2);
            delta = 20;
        }
        if (msVersion == null || msVersion.equals("")) {
            return mrversion * 100 - delta;
        }
        try {
            return mrversion * 100 - delta + Integer.parseInt(msVersion);
        }
        catch (NumberFormatException e) {
            System.out.println(versionError);
            return 0;
        }
    }
}

