/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.lang.ref.WeakReference;
import java.security.Key;
import java.util.IdentityHashMap;
import java.util.Map;
import sun.security.pkcs11.P11Key;
import sun.security.util.Cache;

final class KeyCache {
    private final Cache strongCache = Cache.newHardMemoryCache(16);
    private WeakReference<Map<Key, P11Key>> cacheReference;

    KeyCache() {
    }

    synchronized P11Key get(Key key) {
        Map map;
        P11Key p11Key = (P11Key)this.strongCache.get(new IdentityWrapper(key));
        if (p11Key != null) {
            return p11Key;
        }
        Map map2 = map = this.cacheReference == null ? null : (Map)this.cacheReference.get();
        if (map == null) {
            return null;
        }
        return (P11Key)map.get(key);
    }

    synchronized void put(Key key, P11Key p11Key) {
        IdentityHashMap<Key, P11Key> map;
        this.strongCache.put(new IdentityWrapper(key), p11Key);
        IdentityHashMap<Key, P11Key> identityHashMap = map = this.cacheReference == null ? null : (IdentityHashMap<Key, P11Key>)this.cacheReference.get();
        if (map == null) {
            map = new IdentityHashMap<Key, P11Key>();
            this.cacheReference = new WeakReference(map);
        }
        map.put(key, p11Key);
    }

    private static final class IdentityWrapper {
        final Object obj;

        IdentityWrapper(Object obj) {
            this.obj = obj;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityWrapper)) {
                return false;
            }
            IdentityWrapper other = (IdentityWrapper)o;
            return this.obj == other.obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }
    }
}

