#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 random-fu
version:              0.2.7.7
visibility:           public
id:                   random-fu-0.2.7.7-5nTSNTeM0HyZFp4oC7yp9
key:                  random-fu-0.2.7.7-5nTSNTeM0HyZFp4oC7yp9
license:              LicenseRef-PublicDomain
maintainer:           Dominic Steinitz <dominic@steinitz.org>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/mokus0/random-fu
synopsis:             Random number generation
description:
    Random number generation based on modeling random
    variables in two complementary ways: first, by the
    parameters of standard mathematical distributions and,
    second, by an abstract type ('\''RVar'\'') which can be
    composed and manipulated monadically and sampled in
    either monadic or \"pure\" styles.

    The primary purpose of this library is to support
    defining and sampling a wide variety of high quality
    random variables.  Quality is prioritized over speed,
    but performance is an important goal too.

    In my testing, I have found it capable of speed
    comparable to other Haskell libraries, but still
    a fair bit slower than straight C implementations of
    the same algorithms.

category:             Math
abi:                  8491b0a3b070185969bf3e171664668c
exposed:              True
exposed-modules:
    Data.Random Data.Random.Distribution
    Data.Random.Distribution.Bernoulli Data.Random.Distribution.Beta
    Data.Random.Distribution.Binomial
    Data.Random.Distribution.Categorical
    Data.Random.Distribution.ChiSquare
    Data.Random.Distribution.Dirichlet
    Data.Random.Distribution.Exponential Data.Random.Distribution.Gamma
    Data.Random.Distribution.Multinomial
    Data.Random.Distribution.Normal Data.Random.Distribution.Pareto
    Data.Random.Distribution.Poisson Data.Random.Distribution.Rayleigh
    Data.Random.Distribution.Simplex
    Data.Random.Distribution.StretchedExponential
    Data.Random.Distribution.T Data.Random.Distribution.Triangular
    Data.Random.Distribution.Uniform Data.Random.Distribution.Weibull
    Data.Random.Distribution.Ziggurat Data.Random.Internal.Find
    Data.Random.Internal.Fixed Data.Random.Internal.TH Data.Random.Lift
    Data.Random.List Data.Random.RVar Data.Random.Sample
    Data.Random.Vector

import-dirs:          /usr/lib/ghc-8.10.5/site-local/random-fu-0.2.7.7
library-dirs:         /usr/lib/ghc-8.10.5/site-local/random-fu-0.2.7.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/random-fu-0.2.7.7
hs-libraries:         HSrandom-fu-0.2.7.7-5nTSNTeM0HyZFp4oC7yp9
depends:
    base-4.14.2.0 erf-2.0.0.0-BAjfrhskuQTIFU6BgB8zca
    math-functions-0.3.4.2-IJhAMriziU16J2oMLHgysC
    monad-loops-0.4.3-8Lx5Hn3pTtO62yOPdPW77x mtl-2.2.2
    random-1.2.0-BSVdQCE475yEKcUUPfL4ub
    random-shuffle-0.0.4-8k4VmXLcK065IHSDa1Sevp
    random-source-0.3.0.11-GZSMCf2BpOL57GjVDH5kGj
    rvar-0.2.0.6-7YLsiXTaXupH10bGkMIJ3k
    syb-0.7.2.1-LCeM0k3cWww5FKQVRHAOJq template-haskell-2.16.0.0
    transformers-0.5.6.2 vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-random-fu/html/random-fu.haddock
haddock-html:         /usr/share/doc/haskell-random-fu/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

