#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 BNFC
version:              2.9.0
visibility:           public
id:                   BNFC-2.9.0-51z9jSPTYnZL4uM2sl2Gb9
key:                  BNFC-2.9.0-51z9jSPTYnZL4uM2sl2Gb9
license:              BSD-3-Clause
copyright:
    (c) Andreas Abel, Jonas Almström Duregård, Krasimir Angelov, Jean-Philippe Bernardy, Björn Bringert, Johan Broberg, Kyle Butt, Paul Callaghan, Grégoire Détrez, Markus Forsberg, Ola Frid, Peter Gammie, Thomas Hallgren, Pascal Hof, Simon Huber, Patrik Jansson, Kristofer Johannisson, Antti-Juhani Kaijanaho, Andreas Lööw, Justin Meiners, Kent Mein, Ulf Norell, Gabriele Paganelli, Michael Pellauer, Fabian Ruch, and Aarne Ranta 2002 - 2020. Free software under the BSD 3-clause license.

maintainer:           bnfc-dev@googlegroups.com
homepage:             http://bnfc.digitalgrammars.com/
synopsis:             A compiler front-end generator.
description:
    The BNF Converter is a compiler construction tool generating a compiler front-end
    from a Labelled BNF grammar. It was originally written to generate Haskell code,
    but can also be used for generating Agda, C, C++, Java, Ocaml and XML code.

    Given a Labelled BNF grammar the tool produces:
    an abstract syntax as a Haskell, Agda, C, C++, Ocaml module or Java directory,
    a case skeleton for the abstract syntax in the same language,
    an Alex, JLex, or Flex lexer generator file,
    a Happy, CUP, Bison, or Antlr parser generator file,
    a pretty-printer as a Haskell, Agda, C, C++, Java, or Ocaml module,
    an XML representation,
    a LaTeX file containing a readable specification of the language.

category:             Development
abi:                  b5ecd05fbbce6011f6a2a9ea1f1ed097
exposed:              True
exposed-modules:
    BNFC.Abs BNFC.Backend.Agda BNFC.Backend.Base BNFC.Backend.C
    BNFC.Backend.C.CFtoBisonC BNFC.Backend.C.CFtoCAbs
    BNFC.Backend.C.CFtoCPrinter BNFC.Backend.C.CFtoCSkel
    BNFC.Backend.C.CFtoFlexC BNFC.Backend.C.RegToFlex
    BNFC.Backend.CPP.Makefile BNFC.Backend.CPP.Naming
    BNFC.Backend.CPP.NoSTL BNFC.Backend.CPP.NoSTL.CFtoBison
    BNFC.Backend.CPP.NoSTL.CFtoCPPAbs BNFC.Backend.CPP.NoSTL.CFtoFlex
    BNFC.Backend.CPP.PrettyPrinter BNFC.Backend.CPP.STL
    BNFC.Backend.CPP.STL.CFtoBisonSTL
    BNFC.Backend.CPP.STL.CFtoCVisitSkelSTL
    BNFC.Backend.CPP.STL.CFtoSTLAbs BNFC.Backend.CPP.STL.STLUtils
    BNFC.Backend.Common BNFC.Backend.Common.Makefile
    BNFC.Backend.Common.NamedVariables BNFC.Backend.Common.OOAbstract
    BNFC.Backend.Common.StrUtils BNFC.Backend.Haskell
    BNFC.Backend.Haskell.CFtoAbstract BNFC.Backend.Haskell.CFtoAlex3
    BNFC.Backend.Haskell.CFtoHappy BNFC.Backend.Haskell.CFtoLayout
    BNFC.Backend.Haskell.CFtoPrinter BNFC.Backend.Haskell.CFtoTemplate
    BNFC.Backend.Haskell.HsOpts BNFC.Backend.Haskell.MkErrM
    BNFC.Backend.Haskell.Utils BNFC.Backend.HaskellGADT
    BNFC.Backend.HaskellGADT.CFtoAbstractGADT
    BNFC.Backend.HaskellGADT.CFtoTemplateGADT
    BNFC.Backend.HaskellGADT.HaskellGADTCommon BNFC.Backend.Java
    BNFC.Backend.Java.CFtoAbstractVisitor
    BNFC.Backend.Java.CFtoAllVisitor BNFC.Backend.Java.CFtoAntlr4Lexer
    BNFC.Backend.Java.CFtoAntlr4Parser
    BNFC.Backend.Java.CFtoComposVisitor BNFC.Backend.Java.CFtoCup15
    BNFC.Backend.Java.CFtoFoldVisitor BNFC.Backend.Java.CFtoJLex15
    BNFC.Backend.Java.CFtoJavaAbs15 BNFC.Backend.Java.CFtoJavaPrinter15
    BNFC.Backend.Java.CFtoVisitSkel15 BNFC.Backend.Java.RegToAntlrLexer
    BNFC.Backend.Java.RegToJLex BNFC.Backend.Java.Utils
    BNFC.Backend.Latex BNFC.Backend.OCaml
    BNFC.Backend.OCaml.CFtoOCamlAbs BNFC.Backend.OCaml.CFtoOCamlLex
    BNFC.Backend.OCaml.CFtoOCamlPrinter
    BNFC.Backend.OCaml.CFtoOCamlShow
    BNFC.Backend.OCaml.CFtoOCamlTemplate
    BNFC.Backend.OCaml.CFtoOCamlTest BNFC.Backend.OCaml.CFtoOCamlYacc
    BNFC.Backend.OCaml.OCamlUtil BNFC.Backend.Pygments
    BNFC.Backend.Txt2Tag BNFC.Backend.XML BNFC.CF BNFC.Check.EmptyTypes
    BNFC.GetCF BNFC.Lex BNFC.Lexing BNFC.License BNFC.Options BNFC.Par
    BNFC.PrettyPrint BNFC.Print BNFC.Regex BNFC.TypeChecker BNFC.Utils

hidden-modules:       Paths_BNFC
import-dirs:          /usr/lib/ghc-8.10.3/site-local/BNFC-2.9.0
library-dirs:         /usr/lib/ghc-8.10.3/site-local/BNFC-2.9.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.3/BNFC-2.9.0
hs-libraries:         HSBNFC-2.9.0-51z9jSPTYnZL4uM2sl2Gb9
depends:
    array-0.5.4.0 base-4.14.1.0 containers-0.6.2.1 deepseq-1.4.4.0
    directory-1.3.6.0 filepath-1.4.2.1 mtl-2.2.2 pretty-1.1.3.6
    process-1.6.9.0 string-qq-0.0.4-9yrEgl4b2V423cEe212aMn time-1.9.3

haddock-interfaces:   /usr/share/doc/bnfc/html/BNFC.haddock
haddock-html:         /usr/share/doc/bnfc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

