var RAL = {
    debug: !1
};
RAL.Heap = function() {
    this.items = []
}, RAL.Heap.prototype = {
    getNextHighestPriority: function() {
        var e = 1;
        return this.items[0] && (e = this.items[0].priority + 1), e
    },
    parentIndex: function(e) {
        return Math.floor(.5 * e)
    },
    leftChildIndex: function(e) {
        return 2 * e
    },
    rightChildIndex: function(e) {
        return 2 * e + 1
    },
    get: function(e) {
        var t = null;
        return e >= 1 && this.items[e - 1] && (t = this.items[e - 1]), t
    },
    set: function(e, t) {
        this.items[e - 1] = t
    },
    swap: function(e, t) {
        var n = this.get(e);
        this.set(e, this.get(t)), this.set(t, n)
    },
    upHeap: function(e) {
        var t = null,
            n = null,
            i = null,
            o = !1;
        do o = !1, i = this.parentIndex(e), t = this.get(e), n = this.get(i), o = null !== n && t.priority > n.priority, o && (this.swap(e, i), e = i); while (o)
    },
    downHeap: function(e) {
        var t = null,
            n = null,
            i = null,
            o = null,
            r = null,
            s = null,
            a = !1;
        do a = !1, o = this.leftChildIndex(e), r = this.rightChildIndex(e), t = this.get(e) && this.get(e).priority, n = this.get(o) && this.get(o).priority, i = this.get(r) && this.get(r).priority, null === n && (n = Number.NEGATIVE_INFINITY), null === i && (i = Number.NEGATIVE_INFINITY), s = Math.max(n, i), s > t && (i === s ? (this.swap(e, r), e = r) : (this.swap(e, o), e = o), a = !0); while (a)
    },
    add: function(e) {
        this.items.push(e), this.upHeap(this.items.length)
    },
    remove: function() {
        var e = null;
        return this.items.length && (this.swap(1, this.items.length), e = this.get(this.items.length), this.items.length -= 1, this.downHeap(1)), e
    }
}, RAL.Sanitiser = function() {
    function e(e) {
        return e.replace(/.*?:\/\//, "", e)
    }
    return {
        cleanURL: e
    }
}(), RAL.CacheParser = function() {
    function e(e) {
        var t = /max\-age=(\d+)/gi,
            n = /Cache-Control:.*?no\-cache/gi,
            i = /Cache-Control:.*?no\-store/gi,
            o = /Cache-Control:.*?must\-revalidate/gi,
            r = /Expires:\s(.*)/gi,
            s = [],
            a = t.exec(e),
            l = Date.now();
        return i.test(e) && s.push("Cache-Control: no-store is set"), n.test(e) && s.push("Cache-Control: no-cache is set"), o.test(e) && s.push("Cache-Control: must-revalidate is set"), null !== a ? l = Date.now() + 1e3 * a[1] : (a = r.exec(e), null !== a ? l = Date.parse(a[1]) : s.push("Cache-Control: max-age and Expires: headers are not set")), {
            headers: e,
            cacheable: 0 === s.length,
            useBy: l,
            warnings: s
        }
    }
    return {
        parse: e
    }
}(), RAL.FileSystem = function() {
    function e() {
        return l
    }

    function t(e) {
        c.push(e)
    }

    function n(e, t, n) {
        l && (e = RAL.Sanitiser.cleanURL(e), h.getFile(e, {}, function(e) {
            t(e.toURL())
        }, n))
    }

    function i(e, t, n) {
        l && (e = RAL.Sanitiser.cleanURL(e), h.getFile(e, {}, function(e) {
            e.file(function(e) {
                var n = new FileReader;
                n.onloadend = function() {
                    t(this.result)
                }, n.readAsText(e)
            })
        }, n))
    }

    function o(e, t, n) {
        if (l) {
            e = RAL.Sanitiser.cleanURL(e);
            var i = e.split("/");
            i.pop(), r(h, i, function() {
                h.getFile(e, {
                    create: !0
                }, function(e) {
                    e.createWriter(function(i) {
                        i.onwriteend = function() {
                            i.onwriteend = function() {
                                n(e.toURL())
                            }, i.truncate(t.size)
                        }, i.onerror = function(e) {
                            console.warn("Write failed: " + e.toString())
                        }, i.write(t)
                    }, u.onError)
                }, u.onError)
            })
        }
    }

    function r(e, t, n) {
        ("." === t[0] || "" === t[0]) && (t = t.slice(1)), t.length ? e.getDirectory(t[0], {
            create: !0
        }, function(e) {
            t.length && r(e, t.slice(1), n)
        }, u.onError) : n()
    }

    function s(e, t, n) {
        l && h.getDirectory(e, {}, function(e) {
            e.removeRecursively(t, u.onError)
        }, n || u.onError)
    }

    function a(e, t, n) {
        l && h.getFile(e, {}, function(e) {
            e.remove(t, u.onError)
        }, n || u.onError)
    }
    var l = !1,
        c = [],
        h = null,
        u = {
            onError: function(e) {
                var t = "";
                switch (e.code) {
                    case FileError.QUOTA_EXCEEDED_ERR:
                        t = "QUOTA_EXCEEDED_ERR";
                        break;
                    case FileError.NOT_FOUND_ERR:
                        t = "NOT_FOUND_ERR";
                        break;
                    case FileError.SECURITY_ERR:
                        t = "SECURITY_ERR";
                        break;
                    case FileError.INVALID_MODIFICATION_ERR:
                        t = "INVALID_MODIFICATION_ERR";
                        break;
                    case FileError.INVALID_STATE_ERR:
                        t = "INVALID_STATE_ERR";
                        break;
                    default:
                        t = "Unknown Error"
                }
                console.error("Error: " + t, e)
            },
            onInitialised: function(e) {
                if (h = e.root, l = !0, c.length)
                    for (var t = c.length; t--;) c[t]()
            }
        };
    return function(e) {
        e = e || 10, window.requestFileSystem = window.requestFileSystem || window.webkitRequestFileSystem, window.resolveLocalFileSystemURL = window.resolveLocalFileSystemURL || window.webkitResolveLocalFileSystemURL, window.requestFileSystem && window.requestFileSystem(window.TEMPORARY, 1024 * 1024 * e, u.onInitialised, u.onError)
    }(), {
        isReady: e,
        registerOnReady: t,
        getPath: n,
        getDataAsText: i,
        set: o,
        removeFile: a,
        removeDir: s
    }
}(), RAL.FileManifest = function() {
    function e() {
        return h
    }

    function t(e) {
        u.push(e)
    }

    function n(e, t) {
        var n = RAL.Sanitiser.cleanURL(e),
            i = c[n] || null;
        t(i)
    }

    function i(e, t, n) {
        var i = RAL.Sanitiser.cleanURL(e);
        c[i] = t, a(n)
    }

    function o() {
        c = {}, a()
    }

    function r() {
        s("{}")
    }

    function s(e) {
        if (h = !0, c = JSON.parse(e), u.length)
            for (var t = u.length; t--;) u[t]()
    }

    function a(e) {
        var t = new Blob([JSON.stringify(c)], {
            type: "application/json"
        });
        RAL.FileSystem.set("manifest.json", t, function() {
            e && e()
        })
    }

    function l() {
        RAL.FileSystem.getDataAsText("manifest.json", s, r)
    }
    var c = null,
        h = !1,
        u = [];
    return RAL.FileSystem.isReady() ? l() : RAL.FileSystem.registerOnReady(l), {
        isReady: e,
        registerOnReady: t,
        get: n,
        set: i,
        reset: o
    }
}(), RAL.RemoteFile = function() {}, RAL.RemoteFile.prototype = {
    element: null,
    src: null,
    autoLoad: !1,
    ignoreCacheHeaders: !1,
    timeToLive: 12096e5,
    priority: 0,
    loaded: !1,
    wURL: window.URL || window.webkitURL,
    callbacks: {
        onCacheError: function(e) {
            e.src = this.src, this.sendEvent("cacheerror", e)
        },
        onRemoteFileLoaded: function(e, t) {
            if (this.ignoreCacheHeaders && (t.cacheable = !0, t.useBy += this.timeToLive), t.cacheable) RAL.FileSystem.set(this.src, e, this.callbacks.onFileSystemSet.bind(this, t));
            else {
                var n = this.wURL.createObjectURL(e);
                this.callbacks.onLocalFileLoaded.call(this, n), this.callbacks.onCacheError.call(this, t)
            }
            this.sendEvent("remoteloaded", t)
        },
        onRemoteFileUnavailable: function() {
            this.sendEvent("remoteunavailable")
        },
        onLocalFileLoaded: function(e) {
            this.loaded = !0, this.sendEvent("loaded", e)
        },
        onLocalFileUnavailable: function() {
            this.showPlaceholder(), this.loadFromRemote(), this.sendEvent("localunavailable")
        },
        onFileSystemSet: function(e) {
            RAL.FileManifest.set(this.src, e, this.callbacks.onFileManifestSet.bind(this))
        },
        onFileManifestSet: function() {
            this.load()
        },
        onFileManifestGet: function(e) {
            var t = Date.now();
            null !== e ? e.useBy > t || !RAL.NetworkMonitor.isOnline() ? RAL.FileSystem.getPath(this.src, this.callbacks.onLocalFileLoaded.bind(this), this.callbacks.onLocalFileUnavailable.bind(this)) : this.loadFromRemote() : this.loadFromRemote()
        }
    },
    sendEvent: function(e, t) {
        this.checkForElement();
        var n = document.createEvent("Event");
        n.initEvent(e, !0, !0), t && (n.data = t), this.element.dispatchEvent(n)
    },
    loadFromRemote: function() {
        RAL.Loader.load(this.src, "blob", this.callbacks.onRemoteFileLoaded.bind(this), this.callbacks.onRemoteFileUnavailable.bind(this)), this.sendEvent("remoteloadstart")
    },
    load: function() {
        RAL.FileManifest.get(this.src, this.callbacks.onFileManifestGet.bind(this))
    },
    checkForElement: function() {
        this.element || (this.element = document.createElement("span"))
    },
    addEventListener: function(e, t, n) {
        this.checkForElement(), this.element.addEventListener(e, t, n)
    }
}, RAL.RemoteImage = function(e) {
    RAL.RemoteFile.call(this), e = e || {}, this.element = e.element || document.createElement("img"), this.src = this.element.dataset.src || e.src, this.width = this.element.width || e.width || null, this.height = this.element.height || e.height || null, this.placeholder = this.element.dataset.placeholder || null, this.priority = e.priority || 0, this.addEventListener("remoteloadstart", this.showPlaceholder.bind(this)), this.addEventListener("loaded", this.showImage.bind(this)), "undefined" != typeof e.autoLoad && (this.autoLoad = e.autoLoad), "undefined" != typeof e.ignoreCacheHeaders && (this.ignoreCacheHeaders = e.ignoreCacheHeaders), this.ignoreCacheHeaders && "undefined" != typeof this.timeToLive && (this.timeToLive = e.timeToLive), this.autoLoad ? this.load() : this.showPlaceholder()
}, RAL.RemoteImage.prototype = new RAL.RemoteFile, RAL.RemoteImage.prototype.showPlaceholder = function() {
    null !== this.placeholder && (this.element.style["-webkit-transition"] = "background-image 0.5s ease-out", this.showImage({
        data: this.placeholder
    }))
}, RAL.RemoteImage.prototype.showImage = function(e) {
    var t = e.data,
        n = new Image,
        i = function(e) {
            this.wURL.revokeObjectURL(e)
        }.bind(this, t),
        o = function() {
            var e = this.width || n.naturalWidth,
                o = this.height || n.naturalHeight;
            this.element.src = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7", this.element.style.backgroundImage = "url(" + t + ")", /blob:/.test(t) && setTimeout(i, 100)
        };
    n.onload = o.bind(this), n.src = t
}, RAL.Loader = function() {
    function e(e, t, n, i) {
        e.abort(), this.load(t, n, i)
    }

    function t(i, o, r, s) {
        if (RAL.NetworkMonitor.isOnline()) {
            var a = new XMLHttpRequest;
            a.responseType = o, a.onerror = n.onError.bind(this, s), a.onload = n.onLoad.bind(this, i, r, s);
            if(RAL.authorization) {
             a.open("GET", i, !0, RAL.authorization.username, RAL.authorization.password);
            } else {
             a.open("GET", i, !0);
            }
            a.send(), RAL.NetworkMonitor.registerForOffline(e.bind(this, a, i, r, s))
        } else RAL.NetworkMonitor.registerForOnline(t.bind(this, i, r, s))
    }
    var n = {
        onLoad: function(e, t, n, i) {
            var o = i.target,
                r = o.response,
                s = RAL.CacheParser.parse(o.getAllResponseHeaders());
            4 === o.readyState && (200 === o.status ? t(r, s) : n(i))
        },
        onError: function(e, t) {
            e(t)
        }
    };
    return {
        load: t
    }
}(), RAL.NetworkMonitor = function() {
    function e(e) {
        i.push(e)
    }

    function t(e) {
        o.push(e)
    }

    function n() {
        return window.navigator.onLine
    }
    var i = [],
        o = [];
    return window.addEventListener("online", function() {
        for (var e = i.length, t = null; e--;) t = i.pop(), t()
    }), window.addEventListener("offline", function() {
        for (var e = o.length, t = null; e--;) t = o.pop(), t()
    }), {
        registerForOnline: e,
        registerForOffline: t,
        isOnline: n
    }
}(), RAL.Queue = function() {
    function e() {
        return r.getNextHighestPriority()
    }

    function t(e) {
        a = e
    }

    function n(e, t) {
        "undefined" == typeof e.priority && (e.priority = r.getNextHighestPriority()), r.add(e), t && i()
    }

    function i() {
        for (; a > s;) {
            if (nextFile = r.remove(), null === nextFile) {
                RAL.debug && console.log("[Connections: " + s + "] - No more images queued");
                break
            }
            nextFile.addEventListener("loaded", l.onFileLoaded), nextFile.load(), RAL.debug && console.log("[Connections: " + s + "] - Loading " + nextFile.src), s++
        }
    }

    function o() {
        r.clear()
    }
    var r = new RAL.Heap,
        s = 0,
        a = 6,
        l = {
            onFileLoaded: function() {
                RAL.debug && console.log("[Connections: " + s + "] - File loaded"), s--, i()
            }
        };
    return {
        getNextHighestPriority: e,
        setMaxConnections: t,
        add: n,
        clear: o,
        start: i
    }
}();
