/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ZapNumberSpinner
extends JSpinner {
    private static final long serialVersionUID = -3475273563365395482L;
    private int minValue;
    private int maxValue;
    private int defaultValue;

    public ZapNumberSpinner() {
        this(0, 0, Integer.MAX_VALUE);
    }

    public ZapNumberSpinner(int minValue, int defaultValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = !this.isValidValue(defaultValue) ? minValue : defaultValue;
        this.setModel(new SpinnerNumberModel(this.defaultValue, minValue, maxValue, 1));
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setFormatterFactory(new DefaultFormatterFactory(new ZapNumberFormatter(minValue, maxValue)));
    }

    private boolean isValidValue(int value) {
        return value >= this.minValue && value <= this.maxValue;
    }

    public void changeToDefaultValue() {
        super.setValue(this.defaultValue);
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Number)) {
            return;
        }
        this.setValue(((Number)value).intValue());
    }

    public void setValue(int value) {
        if (!this.isValidValue(value)) {
            return;
        }
        super.setValue(value);
    }

    @Override
    public Integer getValue() {
        return (Integer)super.getValue();
    }

    public void setEditable(boolean enabled) {
        super.setEnabled(enabled);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEnabled(true);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(enabled);
    }

    private static class ZapNumberFormat
    extends Format {
        private static final long serialVersionUID = 7864449797301371031L;
        private final NumberFormat numberFormat;
        private int minValue;

        public ZapNumberFormat(int minValue) {
            this.minValue = minValue;
            this.numberFormat = NumberFormat.getIntegerInstance();
            this.numberFormat.setGroupingUsed(false);
        }

        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
            return this.numberFormat.formatToCharacterIterator(obj);
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return this.numberFormat.format(obj, toAppendTo, pos);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            if (source.isEmpty()) {
                pos.setIndex(1);
                return this.minValue;
            }
            Object val = this.numberFormat.parseObject(source, pos);
            if (pos.getIndex() != source.length()) {
                pos.setErrorIndex(pos.getIndex());
                pos.setIndex(0);
            }
            return val;
        }
    }

    private static class ZapNumberFormatter
    extends NumberFormatter {
        private static final long serialVersionUID = 4888079030453662194L;
        private int minValue;
        private int maxValue;

        public ZapNumberFormatter(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.setValueClass(Integer.class);
            this.setMinimum(Integer.valueOf(minValue));
            this.setMaximum(Integer.valueOf(maxValue));
            this.setAllowsInvalid(false);
            this.setFormat(new ZapNumberFormat(minValue));
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            Object o;
            block6: {
                o = null;
                try {
                    o = super.stringToValue(text);
                }
                catch (ParseException e) {
                    boolean throwException = true;
                    if (e.getMessage().equals("Value not within min/max range")) {
                        int value = ((Number)this.getFormat().parseObject(text)).intValue();
                        if (value < this.minValue) {
                            o = this.minValue;
                            throwException = false;
                        } else if (value > this.maxValue) {
                            o = this.maxValue;
                            throwException = false;
                        }
                    }
                    if (!throwException) break block6;
                    throw e;
                }
            }
            return o;
        }
    }
}

