/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Plugin;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.PluginHelper;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginUtil {
    private static final Logger LOGGER = LogManager.getLogger(PluginHelper.class);

    private PluginUtil() {
    }

    public static void validateConfig(Plugin plugin, Configuration config) {
        List<String> configErrors = PluginUtil.doValidateConfig(plugin, config);
        if (configErrors.size() > 0) {
            for (String err : configErrors) {
                LOGGER.error(err);
            }
            throw new IllegalStateException("Config errors found for plugin '" + plugin.getName() + "'");
        }
    }

    @VisibleForTesting
    public static List<String> doValidateConfig(Plugin plugin, Configuration config) {
        ArrayList<String> configErrors = new ArrayList<String>();
        List configSchemaNames = plugin.configSchema().stream().map(PluginConfigSpec::name).collect(Collectors.toList());
        Collection<String> providedConfig = config.allKeys();
        for (String string : providedConfig) {
            if (configSchemaNames.contains(string)) continue;
            configErrors.add(String.format("Unknown setting '%s' specified for plugin '%s'", string, plugin.getName()));
        }
        for (PluginConfigSpec pluginConfigSpec : plugin.configSchema()) {
            if (!pluginConfigSpec.required() || providedConfig.contains(pluginConfigSpec.name())) continue;
            configErrors.add(String.format("Required setting '%s' not specified for plugin '%s'", pluginConfigSpec.name(), plugin.getName()));
        }
        return configErrors;
    }
}

