#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 regex-posix
version:              0.96.0.1
visibility:           public
id:                   regex-posix-0.96.0.1-F4JSS9fGdx95aOeG6CtJBb
key:                  regex-posix-0.96.0.1-F4JSS9fGdx95aOeG6CtJBb
license:              BSD-3-Clause
copyright:            Copyright (c) 2007-2010, Christopher Kuklewicz
maintainer:           hvr@gnu.org, Andreas Abel
author:               Christopher Kuklewicz
synopsis:             POSIX Backend for "Text.Regex" (regex-base)
description:
    The POSIX regex backend for <//hackage.haskell.org/package/regex-base regex-base>.

    The main appeal of this backend is that it'\''s very lightweight due to its reliance on the ubiquitous <https://pubs.opengroup.org/onlinepubs/9699919799/basedefs/regex.h.html POSIX.2 regex> facility that is provided by the standard C library on most POSIX platforms.

    See also <https://wiki.haskell.org/Regular_expressions> for more information.

category:             Text
abi:                  1d2824638a009bc3e06e5490244f5e9e
exposed:              True
exposed-modules:
    Text.Regex.Posix Text.Regex.Posix.ByteString
    Text.Regex.Posix.ByteString.Lazy Text.Regex.Posix.Sequence
    Text.Regex.Posix.String Text.Regex.Posix.Wrap

hidden-modules:       Paths_regex_posix
import-dirs:          /usr/lib/ghc-8.10.5/site-local/regex-posix-0.96.0.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/regex-posix-0.96.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/regex-posix-0.96.0.1
hs-libraries:         HSregex-posix-0.96.0.1-F4JSS9fGdx95aOeG6CtJBb
depends:
    array-0.5.4.0 base-4.14.2.0 bytestring-0.10.12.0 containers-0.6.4.1
    regex-base-0.94.0.1-BhcrfAa0EaQLabAeJ8QV4e

haddock-interfaces:   /usr/share/doc/haskell-regex-posix/html/regex-posix.haddock
haddock-html:         /usr/share/doc/haskell-regex-posix/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

