#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 deriving-compat
version:              0.5.10
visibility:           public
id:                   deriving-compat-0.5.10-bbGNznV8wuetgsQMD41Q
key:                  deriving-compat-0.5.10-bbGNznV8wuetgsQMD41Q
license:              BSD-3-Clause
copyright:            (C) 2015-2017 Ryan Scott
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ryan Scott
stability:            Experimental
homepage:             https://github.com/haskell-compat/deriving-compat
synopsis:             Backports of GHC deriving extensions
description:
    Provides Template Haskell functions that mimic deriving
    extensions that were introduced or modified in recent versions
    of GHC. Currently, the following typeclasses/extensions are covered:

    * Deriving @Bounded@

    * Deriving @Enum@

    * Deriving @Ix@

    * Deriving @Eq@, @Eq1@, and @Eq2@

    * Deriving @Ord@, @Ord1@, and @Ord2@

    * Deriving @Read@, @Read1@, and @Read2@

    * Deriving @Show@, @Show1@, and @Show2@

    * @DeriveFoldable@

    * @DeriveFunctor@

    * @DeriveTraversable@

    * @GeneralizedNewtypeDeriving@ (with GHC 8.2 or later)

    * @DerivingVia@ (with GHC 8.2 or later)

    See the "Data.Deriving" module for a full list of backported changes.

    Note that some recent GHC typeclasses/extensions are not covered by this package:

    * @DeriveDataTypeable@

    * @DeriveGeneric@, which was introducted in GHC 7.2 for deriving
    @Generic@ instances, and modified in GHC 7.6 to allow derivation
    of @Generic1@ instances. Use @Generics.Deriving.TH@ from
    @<http://hackage.haskell.org/package/generic-deriving generic-deriving>@
    to derive @Generic(1)@ using Template Haskell.

    * @DeriveLift@, which was introduced in GHC 8.0 for deriving
    @Lift@ instances. Use @Language.Haskell.TH.Lift@ from
    @<http://hackage.haskell.org/package/th-lift th-lift>@
    to derive @Lift@ using Template Haskell.

    * The @Bifunctor@ typeclass, which was introduced in GHC 7.10,
    as well as the @Bifoldable@ and @Bitraversable@ typeclasses, which
    were introduced in GHC 8.2. Use @Data.Bifunctor.TH@ from
    @<http://hackage.haskell.org/package/bifunctors bifunctors>@
    to derive these typeclasses using Template Haskell.

category:             Compatibility
abi:                  1e27645ce20c64e4564102119c927ce9
exposed:              True
exposed-modules:
    Data.Bounded.Deriving Data.Bounded.Deriving.Internal Data.Deriving
    Data.Deriving.Internal Data.Deriving.Via Data.Deriving.Via.Internal
    Data.Enum.Deriving Data.Enum.Deriving.Internal Data.Eq.Deriving
    Data.Eq.Deriving.Internal Data.Foldable.Deriving
    Data.Functor.Deriving Data.Functor.Deriving.Internal
    Data.Ix.Deriving Data.Ix.Deriving.Internal Data.Ord.Deriving
    Data.Ord.Deriving.Internal Data.Traversable.Deriving
    Text.Read.Deriving Text.Read.Deriving.Internal Text.Show.Deriving
    Text.Show.Deriving.Internal

hidden-modules:       Paths_deriving_compat
import-dirs:          /usr/lib/ghc-8.10.5/site-local/deriving-compat-0.5.10
library-dirs:         /usr/lib/ghc-8.10.5/site-local/deriving-compat-0.5.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/deriving-compat-0.5.10
hs-libraries:         HSderiving-compat-0.5.10-bbGNznV8wuetgsQMD41Q
depends:
    base-4.14.2.0 containers-0.6.4.1 ghc-boot-th-8.10.5 ghc-prim-0.6.1
    template-haskell-2.16.0.0
    th-abstraction-0.4.2.0-5X2XqBZ7rCLBwJXut5dQBZ transformers-0.5.6.2
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk

haddock-interfaces:
    /usr/share/doc/haskell-deriving-compat/html/deriving-compat.haddock

haddock-html:         /usr/share/doc/haskell-deriving-compat/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

