<?php
// $Id: simpleblog.php,v 1.28 2003/09/23 10:56:40 kousuke Exp $
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/conf.php';
include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";
class SimpleBlog {
	var $BLOCK_NUM = 10;
	var $LIST_NUM = 50;
	var $VIEW_NUM = 20;
	
	
	var $user_list;
	var $blogUid;
	var $targetUser;
	var $userHander;
	var $permission = -1;
	var $title = '';
	var $usersCache = array();
	var $ts;
	function SimpleBlog($blogUid = -1){
		global $xoopsDB;
		$this->userHander = new XoopsUserHandler($xoopsDB);
		$this->ts =& MyTextSanitizer::getInstance();
		$this->user_list = array();
		$this->blogUid = intval($blogUid);

		
		if($this->blogUid > 0){
			$this->targetUser = $this->userHander->get($this->blogUid);
			if(!$this->targetUser->isActive()){
				redirect_header(SIMPLEBLOG_DIR,2,_MD_NORIGHTTOACCESS);
				exit();
			}
			$usersCache[$this->blogUid] = $this->targetUser;
		}else{
			redirect_header(XOOPS_URL.'/',1,_MD_INTERNALERROR.'(99.0) ['.$this->blogUid.']');
			exit();
		}
	}
	
	function getTargetUname(){
		return $this->targetUser->uname();
	}
	/**
	 * create new blog user
	 */
	function createNewBlogUser($permission = 0, $title = ''){
		global $xoopsUser,$xoopsDB;
		
		$result = $xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$this->blogUid);
		if(list($localuid) = $xoopsDB->fetchRow($result)){
			return false;
		}else{
			$xoopsDB->queryF('insert into '.SIMPLEBLOG_TABLE_INFO.'(uid, blog_permission, last_update, title) values ('.$this->blogUid.', '.intval($permission).', \'0000-00-00\', \''.$title.'\')');
			return true;
		}
	}
	
	function setBlogInfo($permisstion = 0, $title = ""){
		global $xoopsDB;
		$xoopsDB->queryF('update '.SIMPLEBLOG_TABLE_INFO.' set blog_permission = '.intval($permisstion).', title=\''.$title.'\' where uid ='.$this->blogUid);
	}
	
	function deleteAll(){
		global $xoopsDB;
		$xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$this->blogUid);
		$xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid);
		$xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_COMMENT.' where uid = '.$this->blogUid);
	}
	
	function loadBlogInfo(){
		global $xoopsUser,$xoopsDB;
		$sql = 'select blog_permission, title from '.SIMPLEBLOG_TABLE_INFO.' where uid='.$this->targetUser->uid();
		if(!$result = $xoopsDB->query($sql)){
			return false;
		}
		if(list($permission, $title) = $xoopsDB->fetchRow($result)){
			$this->permission = $permission;
			$this->title = $title;
			return true;
		}
		return false;
		
	}
	function canWrite(){
		global $xoopsUser, $xoopsDB;
		if(!$xoopsUser){
			return false;
		}else if($xoopsUser->uid() == $this->blogUid){
			return true;
		}
		return false;	
	}
	
	function canRead(){
		global $xoopsUser, $xoopsDB;
		if($xoopsUser){
			return true;
		}
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		
		if($this->permission < 2){
			return true;
		}
		return false;
	}
	
	function canComment(){
		global $xoopsUser, $xoopsDB;
		if($xoopsUser){
			return true;
		}
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		
		if($this->permission == 0){
			return true;
		}
		return false;
	}
	
	function getTitle(){
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		if($this->title != ''){
			return $this->title;
		}else{
			return _MI_SIMPLEBLOG_TITLE_PREFIX.$this->getTargetUname()._MI_SIMPLEBLOG_TITLE_SUFFIX;
		}
	}
	
	
	function getBlogData($year = 0, $month = 0, $date = 0, $limit = 0){
		global $xoopsUser, $xoopsDB;
		if($limit == 0){
			$limit = $this->VIEW_NUM;
		}
		$dateFormat = '%y/%m/%d';
		if(!$this->canRead()){
			redirect_header(XOOPS_URL.'/',1,_MD_NORIGHTTOACCESS);
			exit();
		}
		$sql_blog = '';
		
		if( ($year > 1000) && ($month > 0) ){
			if($date > 0){ // display date blog
					if(checkdate($month, $date, $year)){
						$sql_blog = 'select blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and blog_date= \''.$year.'-'.$month.'-'.$date.'\' order by blog_date desc ';
					}
			}else{ // display month blog
				$sql_blog = 'select blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and DATE_FORMAT(blog_date, \'%Y\')='.$year.' and DATE_FORMAT(blog_date, \'%m\') = '.$month.' order by blog_date desc ';
			}
		}
		if($sql_blog == ''){ // display current blog
			$sql_blog = 'select blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' order by blog_date desc limit '.$limit;
		}
		
		if(!$result_blog = $xoopsDB->query($sql_blog)){
			return false;
		}
		$result = array();
		$i = 0;
	
		while(	list(
				$result_date, 
				$result_title,
				$result_post_text
			) = $xoopsDB->fetchRow($result_blog)
		){

			$result['blog'][$i]['year'] = mb_strcut($result_date, 0, 4);
			$result['blog'][$i]['month'] = mb_strcut($result_date, 5, 2);
			$result['blog'][$i]['date'] = mb_strcut($result_date, 8, 2);
			$result['blog'][$i]['date_all'] = $result_date;
			$result['blog'][$i]['title'] = $result_title;
			$result['blog'][$i]['text'] = $this->ts->makeTareaData4Show($result_post_text);
			$result['blog'][$i]['text_edit'] = $this->ts->makeTareaData4Edit($result_post_text);
			$result['blog'][$i]['comments'] = $this->getComments($result_date);
			$i++;
		}
		
		
		$result['blog_num'] = $i;
		$time = time();
		$result['today']['year'] = date('Y',$time);
		$result['today']['month'] = date('m',$time);
		$result['today']['date'] = date('d',$time);
		$result['user'] = $this->targetUser;
		$result['uname'] = $this->targetUser->uname();
		return $result;
	}
	
	
	
	function getBlog1($dates){
		global $xoopsUser, $xoopsDB;
		$sql = 'select title, post_text FROM '.SIMPLEBLOG_TABLE_BLOG.' WHERE uid = '.$this->blogUid.' and  blog_date = \''.$dates['sql_date'].'\'';
		if(!$result_select = $xoopsDB->query($sql)){
			return false;
		}
		$result = array();
		
		$result['year'] = $dates['year'];
		$result['month'] = $dates['month'];
		$result['date'] = $dates['date'];
			
		if(list($title, $text) = $xoopsDB->fetchRow($result_select)){
			
			$result['date_all'] = $dates['sql_date'];
			$result['title'] = $title;
			$result['text'] = $this->ts->makeTareaData4Show($text);
			$result['text_edit'] = $this->ts->makeTareaData4Edit($text);
		}
		return $result;
	}
	
	
	function updateBlog($dates, $text, $title = ''){
		global $xoopsUser, $xoopsDB;
		//$myts =& MyTextSanitizer::getInstance();
		
		$sqlDate = $this->escapeHtml($dates['sql_date']);
		$sqlText = $this->ts->makeTareaData4Save($this->escapeHtml($text));
		$sqlTitle = $this->ts->makeTareaData4Save($this->escapeHtml($title));
		$uid = $xoopsUser->uid();
		if(empty($text)){
			$sql = sprintf("delete from %s where uid=%u and blog_date='%s'", SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate);
		}else{
			$sql = sprintf("select uid from %s where uid = %u and blog_date = '%s'",SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate);
			if(!$result_select = $xoopsDB->query($sql)){
				return false;
			}
			if($xoopsDB->getRowsNum($result_select) == 0){
				$sql = sprintf("insert into %s(uid, blog_date, title, post_text) values(%u, '%s', '%s', '%s')", SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate, $sqlTitle, $sqlText);
			}else{
				$sql = sprintf("update %s set title = '%s', post_text = '%s' where uid = %u and blog_date ='%s'", SIMPLEBLOG_TABLE_BLOG, $sqlTitle, $sqlText, $uid, $sqlDate);
			}
		}
		$xoopsDB->queryF($sql);
		$this->update();
		return true;
	}
	
	function update(){
		global $xoopsDB;
		$sql = 'update '.SIMPLEBLOG_TABLE_INFO.' set last_update = CURRENT_TIMESTAMP() where uid = '.$this->blogUid;
		$xoopsDB->queryF($sql);
	}
	
	function insertComment($dates, $name, $comment){
		global $xoopsUser, $xoopsDB;
		$uid = 0;
		if($xoopsUser){
			$uid = $xoopsUser->uid();
		}
		$sqlDate = $this->escapeHtml($dates['sql_date']);
		$sqlName = $this->escapeHtml($name);
		$sqlComment = $this->escapeHtml($comment); 
		$sql = sprintf("select count(*) from %s where uid = %u and blog_date = '%s'",SIMPLEBLOG_TABLE_BLOG, $this->blogUid, $sqlDate);
		if(!$result_select = $xoopsDB->query($sql)){
			return false;
		}
		if($xoopsDB->getRowsNum($result_select) == 1){
			$sql_base = "insert into %s (uid, blog_date, comment_id, comment_uid, comment_name, post_text) values(%u, '%s', null, %u, '%s', '%s')";
			$sql = sprintf($sql_base, SIMPLEBLOG_TABLE_COMMENT, $this->blogUid, $sqlDate, $uid, $sqlName, $sqlComment);
			$result = $xoopsDB->queryF($sql);
			
			$this->update();
			return true;
		}
		return false;
	}
	
	function escapeHtml($text){
		$result = $text;
		// $result = ereg_replace('&', '&amp;', $text);
		$result = ereg_replace('<', '&lt;', $result);
		$result = ereg_replace('>', '&gt;', $result);
		// $result = ereg_replace('\'', '&apos;', $result);
		$result = ereg_replace('"', '&quot;', $result);
		//$result = ereg_replace('\r\n', '\n', $result);
		//$result = ereg_replace('\r', '\n', $result);
		//$result = ereg_replace('\n', '<br />', $result);
		return $result;
	}
	
	function getBlogIndex(){
		global $xoopsUser, $xoopsDB;
		$sql = 'select distinct DATE_FORMAT(blog_date, \'%Y\') year, DATE_FORMAT(blog_date, \'%m\') month from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and blog_date != \'0000-00-00\' order by year desc, month';
		if(!$result_select = $xoopsDB->query($sql)){
			return false;
		}
		$result = array();
		while(list($year, $month) = $xoopsDB->fetchRow($result_select)){
			$result[$year][$month] = $month;
		}
		return $result;
	}
	
	function getComments($blogDate){
		global $xoopsUser, $xoopsDB;
		$sql = 'select comment_id, comment_uid,comment_name, post_text from '.SIMPLEBLOG_TABLE_COMMENT.' where uid = '.$this->blogUid.' and blog_date = '.$xoopsDB->quoteString($blogDate).' order by comment_id '; 
		if(!$result_select = $xoopsDB->query($sql)){
			return false;
		}
		$i = 0;
		$comments = array();
		
		while(
			list($comment_id, $comment_uid, $comment_name, $post_text) = $xoopsDB->fetchRow($result_select)
		){
			$comments[$i]['id'] = $comment_id;
			$comments[$i]['uid'] = $comment_uid;
			if($comment_uid > 0){
				if(!in_array($comment_uid, $this->usersCache)){
					$this->usersCache[$comment_uid] = $this->userHander->get($comment_uid);
				}
				$comments[$i]['name'] = $this->usersCache[$comment_uid]->uname();
			}else{
				$comments[$i]['name'] = $comment_name.'@'._MI_SIMPLEBLOG_FORM_GUEST;
			}
			$comments[$i]['comment'] = $post_text;
			$i++;
		}
		return $comments;
	}
	
	function getCompleteDateFromHttpParams(){
		global $HTTP_POST_VARS, $HTTP_GET_VARS;
		$result = array();
		$result['year'] = isset($HTTP_POST_VARS['year']) ? intval($HTTP_POST_VARS['year']) : 0;
		if($result['year'] == 0){
			$result['year'] = isset($HTTP_GET_VARS['year']) ? intval($HTTP_GET_VARS['year']) : 0;
		}
		$result['month'] = isset($HTTP_POST_VARS['month']) ? intval($HTTP_POST_VARS['month']) : 0;
		if($result['month'] == 0){
			$result['month'] = isset($HTTP_GET_VARS['month']) ? intval($HTTP_GET_VARS['month']) : 0;
		}
		$result['date'] = isset($HTTP_POST_VARS['date']) ? intval($HTTP_POST_VARS['date']) : 0;
		if($result['date'] == 0){
			$result['date'] = isset($HTTP_GET_VARS['date']) ? intval($HTTP_GET_VARS['date']) : 0;
		}
		if($result['year'] != 0){
			if( ($result['year'] < 1000) || ($result['year'] > 3000) ){
				return false;
			}
		}
		if($result['month'] != 0){
			if( ($result['month'] < 1) || ($result['month'] > 12) ){
				return false;
			}
		}
		
		if($result['date'] != 0){
			if( ($result['date'] < 1) || ($result['date'] > 31) ){
				return false;
			}
			return $this->dateCheck($result);
		}else{
			return $result;	
		}
	}
	
	function getDateFromHttpParams(){
		global $HTTP_POST_VARS, $HTTP_GET_VARS;
		$result = array();
		$result['year'] = isset($HTTP_POST_VARS['year']) ? intval($HTTP_POST_VARS['year']) : 0;
		if($result['year'] == 0){
			$result['year'] = isset($HTTP_GET_VARS['year']) ? intval($HTTP_GET_VARS['year']) : 0;
		}
		$result['month'] = isset($HTTP_POST_VARS['month']) ? intval($HTTP_POST_VARS['month']) : 0;
		if($result['month'] == 0){
			$result['month'] = isset($HTTP_GET_VARS['month']) ? intval($HTTP_GET_VARS['month']) : 0;
		}
		$result['date'] = isset($HTTP_POST_VARS['date']) ? intval($HTTP_POST_VARS['date']) : 0;
		if($result['date'] == 0){
			$result['date'] = isset($HTTP_GET_VARS['date']) ? intval($HTTP_GET_VARS['date']) : 0;
		}
		
		// check params
		if($result['year'] != 0){
			if( ($result['year'] < 1000) || ($result['year'] > 3000) ){
				return false;
			}
		}
		if($result['month'] != 0){
			if( ($result['month'] < 1) || ($result['month'] > 12) ){
				return false;
			}
		}
		
		if($result['date'] != 0){
			if( ($result['date'] < 1) || ($result['date'] > 31) ){
				return false;
			}
			return $this->dateCheck($result);
		}else{
			if(!checkdate($result['month'], 1, $result['year'])){
				return false;
			}
		}
		
		return $result;
	}
	
	function dateCheck($dates){
		if(!checkdate($dates['month'], $dates['date'], $dates['year'])){
			return false;
		}
		
		$dates['sql_date'] = sprintf("%04u-%02u-%02u", $dates['year'], $dates['month'], $dates['date']);
		return $dates;
	}
}

?>