<?php
/*
Plugin Name: SPAM Champuru for WordPress
Plugin URI:  http://wppluginsj.sourceforge.jp/spam-champuru/
Description: スパムちゃんぷるーのDNSブラックリストに含まれるIPアドレスの場合、拒否します。
Author: wokamoto
Version: 0.3.1
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2008 - 2009 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

function check_spam_champuru($ip, $email, $date) {
	$spam_IP  = '127.0.0.2';
	$host     = "dnsbl.spam-champuru.livedoor.com";
	$pattern  = '/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/';
	$check_IP = trim(preg_match($pattern, $ip) ? $ip : $_SERVER['REMOTE_ADDR']);
	$spam     = false;
	if (preg_match($pattern, $check_IP)) {
		$host = implode('.',array_reverse(split('\.',$check_IP))) . '.' . $host;
		if (function_exists('dns_get_record')) {
			$check_recs = dns_get_record($host, DNS_A);
			if (isset($check_recs[0]['ip'])) $spam = ($check_recs[0]['ip'] === $spam_IP);
			unset($check_recs);
		} elseif (function_exists('gethostbyname')) {
			$checked = (gethostbyname($host) === $spam_IP);
		} elseif (class_exists('Net_DNS_Resolver')) {
			$resolver = new Net_DNS_Resolver();
			$response = $resolver->query($host, 'A');
			if ($response) {
				foreach ($response->answer as $rr) {
					if ($rr->type === 'A') {
						$spam = ($rr->address === $spam_IP);
						break;
					}
				}
			}
			unset($response);
			unset($resolver);
		} elseif (function_exists('checkdnsrr')) {
			$spam = (checkdnsrr($host, "A") === true);
		}
	}
	if ($spam) {
		wp_die(__('エラー: スパムちゃんぷるーDNSBL(http://spam-champuru.livedoor.com/dnsbl/)に登録されているホストからはコメントできません。', 'spam-champuru'));
	}
}
add_action('check_comment_flood', 'check_spam_champuru', 10, 3);
?>