<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Services class
     version 0.71
   ================================================== */

class Ktai_Services {
	private $type;

/* ==================================================
 * @param	none
 * @return	object
 */
public function factory($wince = FALSE) {
	$type = NULL;
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (preg_match('#^DoCoMo/#', $ua)) {
		$type = new Ktai_Service_imode;
	} elseif (preg_match('#^J-PHONE/#', $ua)) {
		$type = new Ktai_Service_Softbank_PDC;
	} elseif (preg_match('#^(Vodafone/|MOT-[CV]|SoftBank/)#', $ua)) {
		$type = new Ktai_Service_Softbank_3G;
	} elseif (preg_match('#(DDIPOCKET|WILLCOM);#', $ua)) {
		$type = new Ktai_Service_imode; // WILLCOM uses the same charset as DoCoMo
	} elseif (preg_match('#^(KDDI-|UP\.Browser)#',$ua)) {
		$type = new Ktai_Service_EZweb;
	} elseif (preg_match('#(Nokia\\d+|^Opera Mini)/#', $ua)) {
		$type = new Ktai_Service_Other;
	} elseif (defined('KS_DEBUG') && preg_match('#Camino#', $ua)) {
		$type = new Ktai_Service_Softbank_PDC;
	} elseif ($wince) {
		if (preg_match('#Windows CE; SHARP/WS\\d+SH; .*Opera#', $ua)) {
			$type = new Ktai_Service_imode; // WILLCOM
		} elseif (preg_match('#Windows CE; SHARP/S\\d+SH; .*Opera#', $ua)) {
			$type = new Ktai_Service_Other; // E-Mobile
		}
	}
	return $type;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Other class
   ================================================== */

class Ktai_Service_Other extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	return $buffer;
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('#<img localsrc="(.*?)"( alt="(.*?)")? ?/?>#', '\3', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_EZweb class
   ================================================== */

class Ktai_Service_EZweb extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	return $buffer;
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('#<img localsrc="(.*?)"( alt=".*?")? ?/?>#', '<img localsrc="\\1">', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode class
   ================================================== */

class Ktai_Service_imode extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	return $buffer;
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 * Reference: http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/basic/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '&#63913;', // warning (!)
		'2'   => '&#63911;', // exclamation (!)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => '',       // double left triangle
		'8'   => '',       // double right triangle
		'16'  => '&#63651;', // thunder
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'44'  => '&#63647;', // sun
		'46'  => '&#63838;', // clock
		'50'  => '&#63829;', // face (female)
		'51'  => '&#63889;', // heart
		'56'  => '&#63722;', // note
		'63'  => '',       // left arrow
		'64'  => '',       // right arrow
		'68'  => '&#63893;', // smile
		'77'  => '&#63904;', // lamp
		'80'  => '&#63829;', // face (male)
		'94'  => '&#63714;', // camera
		'95'  => '&#63649;', // rain
		'107' => '&#63648;', // cloud
		'108' => '&#63863;', // mail envelope
		'109' => '&#63866;', // money
		'119' => '&#63873;', // magnifier (search)
		'120' => '&#63869;', // key
		'149' => '&#63826;', // pen
		'168' => '&#63683;', // air plane
		'169' => '&#63682;', // boat (ship)
		'172' => '&#63676;', // train
		'180' => '&#63879;', // one
		'181' => '&#63880;', // two
		'182' => '&#63881;', // three
		'183' => '&#63882;', // four
		'184' => '&#63883;', // five
		'185' => '&#63884;', // six
		'186' => '&#63885;', // seven
		'187' => '&#63886;', // eight
		'188' => '&#63887;', // nine
		'190' => '&#63652;', // storm
		'191' => '&#63650;', // snowball
		'192' => '&#63655;', // Aries (Ram)
		'193' => '&#63656;', // Taurus (Bull)
		'194' => '&#63657;', // Gemini (Twins)
		'195' => '&#63658;', // Cancer (Crab)
		'196' => '&#63659;', // Leo (Lion)
		'197' => '&#63660;', // Virgo (Virgin)
		'198' => '&#63661;', // Libra (Scales)
		'199' => '&#63662;', // Scorpius (Scorpion)
		'200' => '&#63663;', // Sagittarius (Archer)
		'201' => '&#63664;', // Capricornus (Goat)
		'202' => '&#63665;', // Aquarius (Water Bearer)
		'203' => '&#63666;', // Pisces (Fishes)
		'204' => '[֎g]', // Ophiuchus (Serpent Bearer)
		'265' => '&#63891;', // heart break
		'299' => '&#63867;', // free
		'303' => '[up!]',    // updated
		'305' => '&#63653;', // fog
		'325' => '&#63888;', // zero
		'334' => '&#63874;', // new
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '#<img localsrc="\\1"( alt=".*?")? ?/?>#', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank class
   ================================================== */

class Ktai_Service_Softbank extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 * Reference: http://developers.softbankmobile.co.jp/dp/tool_dl/web/picword_top.php
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '$Fr', // warning (!)
		'2'   => '$OW', // exclamation (!)
		'5'   => '$F[', // left triangle
		'6'   => '$FZ', // right triangle
		'7'   => '$F]', // double left triangle
		'8'   => '$F\', // double right triangle
		'16'  => '$E]', // thunder
		'29'  => '$FR', // up arrow
		'30'  => '$FS', // down arrow
		'32'  => '',    // down triangle
		'33'  => '',    // up triangle
		'34'  => '',    // double down triangle
		'35'  => '',    // double up triangle
		'44'  => '$Gj', // sun
		'46'  => '$GF', // clock
		'50'  => '$G"', // face (female)
		'51'  => '$GB', // heart
		'56'  => '$O!', // note
		'63'  => '$FU', // left arrow
		'64'  => '$FV', // right arrow
		'68'  => '$Gv', // smile
		'80'  => '$G!', // face (male)
		'77'  => '$E/', // lamp
		'94'  => '$G(', // camera
		'95'  => '$Gk', // rain
		'107' => '$Gi', // cloud
		'108' => '$E#', // mail envelope
		'109' => '$EO', // money
		'119' => '$E4', // magnifier (search)
		'120' => '$G_', // key
		'149' => '$O!', // pen
		'168' => '$G=', // air plane
		'169' => '$F"', // boat (ship)
		'172' => '$G>', // train
		'180' => '$F<', // one
		'181' => '$F=', // two
		'182' => '$F>', // three
		'183' => '$F?', // four
		'184' => '$F@', // five
		'185' => '$FA', // six
		'186' => '$FB', // seven
		'187' => '$FC', // eight
		'188' => '$FD', // nine
		'190' => '$Pc', // storm
		'191' => '$Gh', // snowball
		'192' => '$F_', // Aries (Ram)
		'193' => '$F`', // Taurus (Bull)
		'194' => '$Fa', // Gemini (Twins)
		'195' => '$Fb', // Cancer (Crab)
		'196' => '$Fc', // Leo (Lion)
		'197' => '$Fd', // Virgo (Virgin)
		'198' => '$Fe', // Libra (Scales)
		'199' => '$Ff', // Scorpius (Scorpion)
		'200' => '$Fg', // Sagittarius (Archer)
		'201' => '$Fh', // Capricornus (Goat)
		'202' => '$Fi', // Aquarius (Water Bearer)
		'203' => '$Fj', // Pisces (Fishes)
		'204' => '$Fk', // Ophiuchus (Serpent Bearer)
		'265' => '$GC', // heart break
		'299' => '$F6', // free
		'303' => '$F3', // updated
		'305' => '[]',  // fog
		'325' => '$FE', // zero
		'334' => '$F2', // new
		'\\d+' => '',   // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '#<img localsrc="\\1"( alt=".*?")? ?/?>#', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_3G class
   ================================================== */

class Ktai_Service_Softbank_3G extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_PDC class
   ================================================== */

class Ktai_Service_Softbank_PDC extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	$buffer = preg_replace('#^<\\?xml .*>\\s*<!DOCTYPE .*>\\s*#', '', $buffer);
	$buffer = preg_replace('#<h([1-6])(.*?)</h\\1>#', '<p\\2</p>', $buffer);
	$buffer = preg_replace('|<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>|', '<\\1>', $buffer);
	$buffer = preg_replace('#</li>\\s*#', '', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

?>
