<?php
/*
Plugin Name: Ktai Style
Plugin URI: http://wppluginsj.sourceforge.jp/ktai_style/
Description: Provides lightweight pages for mobile phones.
Author: IKEDA Yuriko
Version: 0.71
Author URI: http://www.yuriko.net/cat/wordpress
*/

/*  Copyright (c) 2007 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//define ('KS_DEBUG', TRUE);

add_action('template_redirect', array('Ktai_Style', 'show_ktai_page'));

/* ==================================================
 *   Ktai_Style class
   ================================================== */

class Ktai_Style {
	static public $template_dir;
	private $template;

/* ==================================================
 * @param	none
 * @return	none
 */
public function show_ktai_page() {
	if (is_robots() || is_feed() || is_trackback()) {
		return;
	}
	require dirname(__FILE__) . '/services.php';
	$ktai = Ktai_Services::factory(TRUE);
	if (! $ktai) {
		return;
	}
	require dirname(__FILE__) . '/tags.php';
	$page = new Ktai_Style();
	echo $ktai->convert_char($ktai->shrink($page->output()));
	exit;
}

/* ==================================================
 * @param	none
 * @return	object
 */
public function __construct() {
	$this->template = $this->load_template();
	return;
}

/* ==================================================
 * @param	none
 * @return	string
 */
private function load_template() {
	self::$template_dir = dirname(__FILE__) . '/templates/';
	if ( is_404() && $template = $this->query_template('404')) {
		return $template;
	} elseif (isset($_GET['arc'])) {
		if ($_GET['arc'] == 'months' && $template = $this->query_template('arc_months')) {
			return $template;
		} elseif ($_GET['arc'] == 'cats' && $template = $this->query_template('arc_cats')) {
			return $template;
		} elseif ($_GET['arc'] == 'pages' && $template = $this->query_template('arc_pages')) {
			return $template;
		}
	} elseif (is_search() && $template = $this->query_template('search')) {
		return $template;
	} elseif (is_home() && $template = $this->get_home_template()) {
		return $template;
	} elseif (is_attachment() && $template = $this->get_attachment_template()) {
		return $template;
	} elseif (is_single() && $template = $this->query_template('single')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_page() && $template = $this->get_page_template()) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_category() && $template = $this->get_category_template()) {
		return $template;
	} elseif (is_author() && $template = $this->query_template('author')) {
		return $template;
	} elseif (is_date() && $template = $this->query_template('date')) {
		return $template;
	} elseif (is_archive() && $template = $this->query_template('archive')) {
		return $template;
	} elseif (is_comments_popup() && $template = $this-> get_comments_popup_template()) {
		return $template;
	} elseif (is_paged() && $template = $this->query_template('paged')) {
		return $template;
	} elseif (file_exists(self::$template_dir . 'index.php')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return self::$template_dir . 'index.php';
	}
	return NULL;
}

/* ==================================================
 * @param	string
 * @return	string
 */
private function query_template($type) {
	$template = '';
	if (file_exists(self::$template_dir . "{$type}.php")) {
		$template = self::$template_dir . "{$type}.php";
	}
	return apply_filters("{$type}_template", $template);
}

/* ==================================================
 * @param	none
 * @return	string
 */
private function get_category_template() {
	$template = '';
	if (file_exists(self::$template_dir . 'category-' . get_query_var('cat') . '.php')) {
		$template = self::$template_dir . 'category-' . get_query_var('cat') . '.php';
	} elseif (file_exists(self::$template_dir . 'category.php')) {
		$template = self::$template_dir . 'category.php';
	}
	return apply_filters('category_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 */
private function get_home_template() {
	$template = '';
	if (file_exists(self::$template_dir . 'home.php')) {
		$template = self::$template_dir . 'home.php';
	} elseif ( file_exists(self::$template_dir . 'index.php')) {
		$template = self::$template_dir . 'index.php';
	}
	return apply_filters('home_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 */
private function get_page_template() {
	if (file_exists(self::$template_dir . 'page.php')) {
		$template = self::$template_dir . 'page.php';
	} else {
		$template = '';
	}
	return apply_filters('page_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 */
private function get_attachment_template() {
	global $posts;
	$type = explode('/', $posts[0]->post_mime_type);
	if ( $template =  $this->query_template($type[0]) )
		return $template;
	elseif ( $template =  $this->query_template($type[1]) )
		return $template;
	elseif ( $template =  $this->query_template("$type[0]_$type[1]") )
		return $template;
	else
		return $this->query_template('attachment');
}

/* ==================================================
 * @param	none
 * @return	string
 */
private function get_comments_popup_template() {
	if (file_exists(self::$template_dir . 'comments-popup.php')) {
		$template = self::$template_dir . 'comments-popup.php';
	} else {
		$template = '';
	}
	return apply_filters('comments_popup_template', $template);
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_header() {
	do_action('get_header');
	if (file_exists(self::$template_dir . 'header.php')) {
		load_template(self::$template_dir . 'header.php');
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_footer() {
	do_action('get_footer');
	if (file_exists(self::$template_dir . 'footer.php')) {
		load_template(self::$template_dir . 'footer.php');
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	string
 */
public function output() {
	ob_start();
	include $this->template;
	$buffer = ob_get_contents();
	ob_end_clean();
	header ("Content-Type: text/html; charset=Shift_JIS");
	return mb_convert_encoding("$buffer", 'SJIS-win', get_bloginfo('charset'));
}

// ===== End of class ====================
}

?>