/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.List;
import java.util.Map;
import woolpack.ee.EEContext;
import woolpack.ee.EEUtils;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.MapEL;
import woolpack.fn.Fn;
import woolpack.validator.SimpleMessageCollector;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorBuilder<E extends Exception> {
    public static final EL DEFALT_MESSAGES_EL = new ArrayPathEL(EEUtils.LOCAL_EL, (EL)new MapEL("woolpack.ee.MESSAGES"));
    private EL messagesEL;
    private boolean valueNotFoundIgnoreFlag;
    private Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn;

    public ValidatorBuilder(Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn, EL messagesEL, boolean valueNotFoundIgnoreFlag) {
        this.validatorFn = validatorFn;
        this.messagesEL = messagesEL;
        this.valueNotFoundIgnoreFlag = valueNotFoundIgnoreFlag;
    }

    public ValidatorBuilder(Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn) {
        this(validatorFn, DEFALT_MESSAGES_EL, false);
    }

    public Fn<EEContext, Void, E> getCheckExpression(final Fn<EEContext, Void, ? extends E> trueFn, final Fn<EEContext, Void, ? extends E> falseFn) {
        return new Fn<EEContext, Void, E>(){

            @Override
            public Void exec(EEContext domContext) throws Exception {
                ValidatorContext validatorContext = new ValidatorContext();
                SimpleMessageCollector collector = new SimpleMessageCollector();
                validatorContext.setCollectable(collector);
                validatorContext.setId(domContext.getId());
                validatorContext.setInputMap(ValidatorUtils.convert(domContext.getInput()));
                Map tmpMap = domContext.getInput();
                try {
                    domContext.setInput(validatorContext.getInputMap());
                    if (((Boolean)ValidatorBuilder.this.validatorFn.exec(validatorContext)).booleanValue()) {
                        trueFn.exec(domContext);
                    } else {
                        ValidatorBuilder.this.messagesEL.setValue(domContext, collector.getList());
                        falseFn.exec(domContext);
                    }
                }
                finally {
                    domContext.setInput(tmpMap);
                }
                return null;
            }
        };
    }

    public Fn<EEContext, Void, E> getReplaceExpression() {
        return new Fn<EEContext, Void, E>(){

            @Override
            public Void exec(EEContext context) {
                List messages = (List)ValidatorBuilder.this.messagesEL.getValue(context);
                if (messages != null) {
                    int size = messages.size();
                    Map<String, Object> config = context.getConfig();
                    int i = 0;
                    while (i < size) {
                        String key = (String)messages.get(i);
                        Object value = config.get(key);
                        if (value == null) {
                            if (!ValidatorBuilder.this.valueNotFoundIgnoreFlag) {
                                throw new IllegalStateException("not found.");
                            }
                        } else {
                            messages.set(i, value);
                        }
                        ++i;
                    }
                }
                return null;
            }
        };
    }

    public EL getMessagesEL() {
        return this.messagesEL;
    }

    public void setMessagesEL(EL messagesEL) {
        this.messagesEL = messagesEL;
    }

    public Fn<? super ValidatorContext, Boolean, ? extends E> getValidatorFn() {
        return this.validatorFn;
    }

    public void setValidatorFn(Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn) {
        this.validatorFn = validatorFn;
    }

    public boolean isValueNotFoundIgnoreFlag() {
        return this.valueNotFoundIgnoreFlag;
    }

    public void setValueNotFoundIgnoreFlag(boolean valueNotFoundIgnoreFlag) {
        this.valueNotFoundIgnoreFlag = valueNotFoundIgnoreFlag;
    }
}

