/*
 * Decompiled with CFR 0.152.
 */
package woolpack.convert;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetMaskConverter<E extends Exception>
implements Fn<String, String, E> {
    private static final int IP_COUNT = 4;
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
    private String netMask;
    private int[] maskArray;

    public NetMaskConverter(String netMask) {
        this.netMask = netMask;
        this.maskArray = NetMaskConverter.toArray(netMask);
    }

    private static int[] toArray(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] a = new int[4];
        int i = 0;
        while (i < a.length) {
            a[i] = Integer.parseInt(m.group(i + 1));
            ++i;
        }
        return a;
    }

    @Override
    public String exec(String c) {
        int[] a = NetMaskConverter.toArray(c);
        if (a == null) {
            return null;
        }
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] & this.maskArray[i];
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < a.length) {
            if (i2 != 0) {
                sb.append('.');
            }
            sb.append(a[i2]);
            ++i2;
        }
        return sb.toString();
    }

    public String getNetMask() {
        return this.netMask;
    }

    public void setNetMask(String netMask) {
        this.netMask = netMask;
        this.maskArray = NetMaskConverter.toArray(netMask);
    }
}

