/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.utils.Utils;

public class ValidatorContextTest extends TestCase {

	public void testTmp() {
		final ValidatorContext context = new ValidatorContext();
		final Map<String, List<Object>> map = new HashMap<String, List<Object>>();
		context.setInputMap(map);

		context.setKey("key0");
		assertNull(context.getValue());

		context.setValue("value0");
		assertEquals("value0", context.getValue());
		assertEquals(Utils.map("key0", Arrays.asList("value0")), context.getInputMap());

		context.setValue("value1");
		assertEquals("value1", context.getValue());
		assertEquals(Utils.map("key0", Arrays.asList("value1")), context.getInputMap());

		context.setKey("key1");
		assertNull(context.getValue());

		context.setValue("value0");
		assertEquals("value0", context.getValue());
		assertEquals(Utils
				.map("key0", Arrays.asList("value1"))
				.map("key1", Arrays.asList("value0")), context.getInputMap());

		context.setValue("value1");
		assertEquals("value1", context.getValue());
		assertEquals(Utils
				.map("key0", Arrays.asList("value1"))
				.map("key1", Arrays.asList("value1")), context.getInputMap());

		map.get("key1").add("value2");
		assertEquals(Utils
						.map("key0", Arrays.asList("value1"))
						.map("key1", Arrays.asList("value1", "value2")), context.getInputMap());
		context.setIndex(1);
		context.setValue("value3");
		assertEquals("value3", context.getValue());
		assertEquals(Utils
						.map("key0", Arrays.asList("value1"))
						.map("key1", Arrays.asList("value1", "value3")), context.getInputMap());
	}
}
