/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import junit.framework.TestCase;

public class AddressedMessageTest extends TestCase {
	public void testEquals() {
		{
			final AddressedMessage obj = new AddressedMessage("key0", 1,
					"message0", Integer.valueOf(1));
			assertTrue(obj.equals(obj));
		}
		assertEquals(
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)),
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)));
		assertFalse(new AddressedMessage("key0", 1, "message0", Integer.valueOf(1))
		.equals(new AddressedMessage("key1", 1, "message0", Integer.valueOf(1))));
		assertFalse(new AddressedMessage("key0", 1, "message0", Integer.valueOf(1))
		.equals(new AddressedMessage("key0", 2, "message0", Integer.valueOf(1))));
		assertFalse(new AddressedMessage("key0", 1, "message0", Integer.valueOf(1))
		.equals(new AddressedMessage("key0", 1, "message1", Integer.valueOf(1))));
		assertFalse(new AddressedMessage("key0", 1, "message0", Integer.valueOf(1))
		.equals(new AddressedMessage("key0", 1, "message0", Integer.valueOf(2))));
		assertFalse(new AddressedMessage("key0", 1, "message0", Integer.valueOf(1))
		.equals(new Object()));
		
		Object o = null;
		if (0 == Integer.valueOf(1).intValue()) {
			o = new Object();
		}
		// findbugsをだますための手続き：oにはnullが格納されている
		assertNull(o);
		assertFalse(new AddressedMessage("key0", 1, "message0", Integer.valueOf(1))
				.equals(o));
	}

	public void testHashCode() {
		assertEquals(
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)).hashCode(),
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)).hashCode());
		assertTrue(
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)).hashCode()
				!= new AddressedMessage("key1", 1, "message0", Integer.valueOf(1)).hashCode());
		assertTrue(
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)).hashCode()
				!= new AddressedMessage("key0", 2, "message0", Integer.valueOf(1)).hashCode());
		assertTrue(
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)).hashCode()
				!= new AddressedMessage("key0", 1, "message1", Integer.valueOf(1)).hashCode());
		assertTrue(
				new AddressedMessage("key0", 1, "message0", Integer.valueOf(1)).hashCode()
				!= new AddressedMessage("key0", 1, "message0", Integer.valueOf(2)).hashCode());
	}

	public void testToString() {
		{
			final AddressedMessage m = new AddressedMessage();
			m.setKey("key0");
			m.setIndex(1);
			m.setMessage("message0");
			m.setValue(Integer.valueOf(1));
			assertEquals("key0", m.getKey());
			assertEquals(1, m.getIndex());
			assertEquals("message0", m.getMessage());
			assertEquals(Integer.valueOf(1), m.getValue());
			assertEquals(
					"AddressedMessage:key=key0,index=1,message=message0,value=1",
					m.toString());
		}
		{
			final AddressedMessage m = new AddressedMessage("key0", 1,
					"message0", Integer.valueOf(1));
			assertEquals("key0", m.getKey());
			assertEquals(1, m.getIndex());
			assertEquals("message0", m.getMessage());
			assertEquals(Integer.valueOf(1), m.getValue());
			assertEquals(
					"AddressedMessage:key=key0,index=1,message=message0,value=1",
					m.toString());
		}
	}
}
