/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import woolpack.fn.Fn;

/**
 * 指定された DOM ノードの子ノードをテキストノードに置き換える{@link Fn}です。
 * 取得した値が null の場合は値を更新しません。
 * 
 * @author nakamura
 * 
 * @param <C>
 * @param <E>
 */
public class ChildTextReplacer<C extends NodeContext, E extends Exception> implements Fn<C, Void, E> {
	private Fn<? super C, String, ? extends E> fn;

	public ChildTextReplacer(final Fn<? super C, String, ? extends E> fn) {
		this.fn = fn;
	}

	public Void exec(final C c) throws E {
		final String value = fn.exec(c);
		if (value != null) {
			XmlUtils.removeChildren(c.getNode());
			XmlUtils.appendText(c.getNode(), value);
		}
		return null;
	}

	public Fn<? super C, String, ? extends E> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, String, ? extends E> fn) {
		this.fn = fn;
	}
}
