/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Element;

import woolpack.fn.Fn;

/**
 * DOM エレメントの属性値を返す{@link Fn}です。
 * @author nakamura
 *
 * @param <E>
 */
public class AttrValueGetter<E extends Exception> implements Fn<NodeContext, String, E> {
	private String attrName;
	
	public AttrValueGetter(final String attrName) {
		this.attrName = attrName;
	}

	public String exec(final NodeContext c) {
		return ((Element) c.getNode()).getAttribute(attrName);
	}

	public String getAttrName() {
		return attrName;
	}
	public void setAttrName(final String attrName) {
		this.attrName = attrName;
	}
}
