/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Map;

class NotNullMap<K, V> extends DelegationMap<K, V> {
	NotNullMap(final Map<K, V> map) {
		super(map);
		checkNotNull(map);
	}

	private void checkNotNull(final Map<? extends K, ? extends V> map) {
		for (final Entry<? extends K, ? extends V> entry : map.entrySet()) {
			entry.getKey().getClass();
			entry.getValue().getClass();
		}
	}

	@Override
	public V put(final K key, final V value) {
		key.getClass();
		value.getClass();
		return super.put(key, value);
	}

	@Override
	public void putAll(final Map<? extends K, ? extends V> map) {
		checkNotNull(map);
		super.putAll(map);
	}
}
