/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Builder パターンを適用した{@link ArrayList}です。
 * 汎用型の配列は禁止されているので
 * {@link java.util.Arrays#asList(Object[])}の代替として定義しています。
 * @author nakamura
 *
 * @param <V>
 */
public class BuildableArrayList<V> extends ArrayList<V> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public BuildableArrayList() {
		super();
	}
	
	/**
	 * {@link #add(Object)}を実行しこのオブジェクトへの参照を返します。
	 * @param v
	 * @return オブジェクトへの参照。
	 */
	public BuildableArrayList<V> list(final V v) {
		add(v);
		return this;
	}
	
	/**
	 * {@link #addAll(Collection)}を実行しこのオブジェクトへの参照を返します。
	 * @param c
	 * @return オブジェクトへの参照。
	 */
	public BuildableArrayList<V> merge(final Collection<? extends V> c) {
		addAll(c);
		return this;
	}
}
