/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import java.util.Collection;
import java.util.List;

import woolpack.fn.Delegator;
import woolpack.fn.Fn;
import woolpack.utils.Utils;

/**
 * {@link List}、{@link Collection}、{@link Iterable}に変換する{@link Fn}です。
 * Javaでは型パラメータを取得する手段がないようなのでコレクションの各要素は変換しません。
 * 変換後の状態変化と変換前の状態変化は相互に伝播します。
 * @author nakamura
 * 
 */
public class ToCollectionViewConverter extends Delegator<ConvertContext, Void, RuntimeException> {

	/**
	 * @param fn {@link ConvertContext#getToType()}が{@link Collection}でない場合の委譲先。
	 */
	public ToCollectionViewConverter(final Fn<ConvertContext, Void, ? extends RuntimeException> fn) {
		super(fn);
	}

	public Void exec(final ConvertContext c) {
		if (List.class.isAssignableFrom(c.getToType())) {
			c.setValue(Utils.toList(c.getValue()));
		} else if (Collection.class.isAssignableFrom(c.getToType())) {
			c.setValue(Utils.toCollection(c.getValue()));
		} else if (Iterable.class.isAssignableFrom(c.getToType())) {
			c.setValue(Utils.toIterable(c.getValue()));
		} else {
			super.exec(c);
		}
		return null;
	}
}
