/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/**
 * 委譲するだけの{@link ResultSet}です。
 * @author nakamura
 *
 */
public class ResultSetAdapter implements ResultSet {
	private ResultSet parent;
	
	public ResultSetAdapter(final ResultSet parent) {
		this.parent = parent;
	}
	public ResultSet getParent() {
		return parent;
	}
	public void setParent(final ResultSet parent) {
		this.parent = parent;
	}

	public boolean absolute(final int row) throws SQLException {
		return parent.absolute(row);
	}

	public void afterLast() throws SQLException {
		parent.afterLast();
	}

	public void beforeFirst() throws SQLException {
		parent.beforeFirst();
	}

	public void cancelRowUpdates() throws SQLException {
		parent.cancelRowUpdates();
	}

	public void clearWarnings() throws SQLException {
		parent.clearWarnings();
	}

	public void close() throws SQLException {
		parent.close();
	}

	public void deleteRow() throws SQLException {
		parent.deleteRow();
	}

	public int findColumn(final String columnName) throws SQLException {
		return parent.findColumn(columnName);
	}

	public boolean first() throws SQLException {
		return parent.first();
	}

	public Array getArray(final int i) throws SQLException {
		return parent.getArray(i);
	}

	public Array getArray(final String colName) throws SQLException {
		return parent.getArray(colName);
	}

	public InputStream getAsciiStream(final int columnIndex) throws SQLException {
		return parent.getAsciiStream(columnIndex);
	}

	public InputStream getAsciiStream(final String columnName) throws SQLException {
		return parent.getAsciiStream(columnName);
	}

	@SuppressWarnings("deprecation")
	public BigDecimal getBigDecimal(final int columnIndex, final int scale) throws SQLException {
		return parent.getBigDecimal(columnIndex, scale);
	}

	public BigDecimal getBigDecimal(final int columnIndex) throws SQLException {
		return parent.getBigDecimal(columnIndex);
	}

	@SuppressWarnings("deprecation")
	public BigDecimal getBigDecimal(final String columnName, final int scale) throws SQLException {
		return parent.getBigDecimal(columnName, scale);
	}

	public BigDecimal getBigDecimal(final String columnName) throws SQLException {
		return parent.getBigDecimal(columnName);
	}

	public InputStream getBinaryStream(final int columnIndex) throws SQLException {
		return parent.getBinaryStream(columnIndex);
	}

	public InputStream getBinaryStream(final String columnName) throws SQLException {
		return parent.getBinaryStream(columnName);
	}

	public Blob getBlob(final int i) throws SQLException {
		return parent.getBlob(i);
	}

	public Blob getBlob(final String colName) throws SQLException {
		return parent.getBlob(colName);
	}

	public boolean getBoolean(final int columnIndex) throws SQLException {
		return parent.getBoolean(columnIndex);
	}

	public boolean getBoolean(final String columnName) throws SQLException {
		return parent.getBoolean(columnName);
	}

	public byte getByte(final int columnIndex) throws SQLException {
		return parent.getByte(columnIndex);
	}

	public byte getByte(final String columnName) throws SQLException {
		return parent.getByte(columnName);
	}

	public byte[] getBytes(final int columnIndex) throws SQLException {
		return parent.getBytes(columnIndex);
	}

	public byte[] getBytes(final String columnName) throws SQLException {
		return parent.getBytes(columnName);
	}

	public Reader getCharacterStream(final int columnIndex) throws SQLException {
		return parent.getCharacterStream(columnIndex);
	}

	public Reader getCharacterStream(final String columnName) throws SQLException {
		return parent.getCharacterStream(columnName);
	}

	public Clob getClob(final int i) throws SQLException {
		return parent.getClob(i);
	}

	public Clob getClob(final String colName) throws SQLException {
		return parent.getClob(colName);
	}

	public int getConcurrency() throws SQLException {
		return parent.getConcurrency();
	}

	public String getCursorName() throws SQLException {
		return parent.getCursorName();
	}

	public Date getDate(final int columnIndex, final Calendar cal) throws SQLException {
		return parent.getDate(columnIndex, cal);
	}

	public Date getDate(final int columnIndex) throws SQLException {
		return parent.getDate(columnIndex);
	}

	public Date getDate(final String columnName, final Calendar cal) throws SQLException {
		return parent.getDate(columnName, cal);
	}

	public Date getDate(final String columnName) throws SQLException {
		return parent.getDate(columnName);
	}

	public double getDouble(final int columnIndex) throws SQLException {
		return parent.getDouble(columnIndex);
	}

	public double getDouble(final String columnName) throws SQLException {
		return parent.getDouble(columnName);
	}

	public int getFetchDirection() throws SQLException {
		return parent.getFetchDirection();
	}

	public int getFetchSize() throws SQLException {
		return parent.getFetchSize();
	}

	public float getFloat(final int columnIndex) throws SQLException {
		return parent.getFloat(columnIndex);
	}

	public float getFloat(final String columnName) throws SQLException {
		return parent.getFloat(columnName);
	}

	public int getInt(final int columnIndex) throws SQLException {
		return parent.getInt(columnIndex);
	}

	public int getInt(final String columnName) throws SQLException {
		return parent.getInt(columnName);
	}

	public long getLong(final int columnIndex) throws SQLException {
		return parent.getLong(columnIndex);
	}

	public long getLong(final String columnName) throws SQLException {
		return parent.getLong(columnName);
	}

	public ResultSetMetaData getMetaData() throws SQLException {
		return parent.getMetaData();
	}

	public Object getObject(final int i, final Map<String, Class<?>> map) throws SQLException {
		return parent.getObject(i, map);
	}

	public Object getObject(final int columnIndex) throws SQLException {
		return parent.getObject(columnIndex);
	}

	public Object getObject(final String colName, final Map<String, Class<?>> map) throws SQLException {
		return parent.getObject(colName, map);
	}

	public Object getObject(final String columnName) throws SQLException {
		return parent.getObject(columnName);
	}

	public Ref getRef(final int i) throws SQLException {
		return parent.getRef(i);
	}

	public Ref getRef(final String colName) throws SQLException {
		return parent.getRef(colName);
	}

	public int getRow() throws SQLException {
		return parent.getRow();
	}

	public short getShort(final int columnIndex) throws SQLException {
		return parent.getShort(columnIndex);
	}

	public short getShort(final String columnName) throws SQLException {
		return parent.getShort(columnName);
	}

	public Statement getStatement() throws SQLException {
		return parent.getStatement();
	}

	public String getString(final int columnIndex) throws SQLException {
		return parent.getString(columnIndex);
	}

	public String getString(final String columnName) throws SQLException {
		return parent.getString(columnName);
	}

	public Time getTime(final int columnIndex, final Calendar cal) throws SQLException {
		return parent.getTime(columnIndex, cal);
	}

	public Time getTime(final int columnIndex) throws SQLException {
		return parent.getTime(columnIndex);
	}

	public Time getTime(final String columnName, final Calendar cal) throws SQLException {
		return parent.getTime(columnName, cal);
	}

	public Time getTime(final String columnName) throws SQLException {
		return parent.getTime(columnName);
	}

	public Timestamp getTimestamp(final int columnIndex, final Calendar cal) throws SQLException {
		return parent.getTimestamp(columnIndex, cal);
	}

	public Timestamp getTimestamp(final int columnIndex) throws SQLException {
		return parent.getTimestamp(columnIndex);
	}

	public Timestamp getTimestamp(final String columnName, final Calendar cal) throws SQLException {
		return parent.getTimestamp(columnName, cal);
	}

	public Timestamp getTimestamp(final String columnName) throws SQLException {
		return parent.getTimestamp(columnName);
	}

	public int getType() throws SQLException {
		return parent.getType();
	}

	@SuppressWarnings("deprecation")
	public InputStream getUnicodeStream(final int columnIndex) throws SQLException {
		return parent.getUnicodeStream(columnIndex);
	}

	@SuppressWarnings("deprecation")
	public InputStream getUnicodeStream(final String columnName) throws SQLException {
		return parent.getUnicodeStream(columnName);
	}

	public URL getURL(final int columnIndex) throws SQLException {
		return parent.getURL(columnIndex);
	}

	public URL getURL(final String columnName) throws SQLException {
		return parent.getURL(columnName);
	}

	public SQLWarning getWarnings() throws SQLException {
		return parent.getWarnings();
	}

	public void insertRow() throws SQLException {
		parent.insertRow();
	}

	public boolean isAfterLast() throws SQLException {
		return parent.isAfterLast();
	}

	public boolean isBeforeFirst() throws SQLException {
		return parent.isBeforeFirst();
	}

	public boolean isFirst() throws SQLException {
		return parent.isFirst();
	}

	public boolean isLast() throws SQLException {
		return parent.isLast();
	}

	public boolean last() throws SQLException {
		return parent.last();
	}

	public void moveToCurrentRow() throws SQLException {
		parent.moveToCurrentRow();
	}

	public void moveToInsertRow() throws SQLException {
		parent.moveToInsertRow();
	}

	public boolean next() throws SQLException {
		return parent.next();
	}

	public boolean previous() throws SQLException {
		return parent.previous();
	}

	public void refreshRow() throws SQLException {
		parent.refreshRow();
	}

	public boolean relative(final int rows) throws SQLException {
		return parent.relative(rows);
	}

	public boolean rowDeleted() throws SQLException {
		return parent.rowDeleted();
	}

	public boolean rowInserted() throws SQLException {
		return parent.rowInserted();
	}

	public boolean rowUpdated() throws SQLException {
		return parent.rowUpdated();
	}

	public void setFetchDirection(final int direction) throws SQLException {
		parent.setFetchDirection(direction);
	}

	public void setFetchSize(final int rows) throws SQLException {
		parent.setFetchSize(rows);
	}

	public void updateArray(final int columnIndex, final Array x) throws SQLException {
		parent.updateArray(columnIndex, x);
	}

	public void updateArray(final String columnName, final Array x) throws SQLException {
		parent.updateArray(columnName, x);
	}

	public void updateAsciiStream(final int columnIndex, final InputStream x, final int length) throws SQLException {
		parent.updateAsciiStream(columnIndex, x, length);
	}

	public void updateAsciiStream(final String columnName, final InputStream x, final int length) throws SQLException {
		parent.updateAsciiStream(columnName, x, length);
	}

	public void updateBigDecimal(final int columnIndex, final BigDecimal x) throws SQLException {
		parent.updateBigDecimal(columnIndex, x);
	}

	public void updateBigDecimal(final String columnName, final BigDecimal x) throws SQLException {
		parent.updateBigDecimal(columnName, x);
	}

	public void updateBinaryStream(final int columnIndex, final InputStream x, final int length) throws SQLException {
		parent.updateBinaryStream(columnIndex, x, length);
	}

	public void updateBinaryStream(final String columnName, final InputStream x, final int length) throws SQLException {
		parent.updateBinaryStream(columnName, x, length);
	}

	public void updateBlob(final int columnIndex, final Blob x) throws SQLException {
		parent.updateBlob(columnIndex, x);
	}

	public void updateBlob(final String columnName, final Blob x) throws SQLException {
		parent.updateBlob(columnName, x);
	}

	public void updateBoolean(final int columnIndex, final boolean x) throws SQLException {
		parent.updateBoolean(columnIndex, x);
	}

	public void updateBoolean(final String columnName, final boolean x) throws SQLException {
		parent.updateBoolean(columnName, x);
	}

	public void updateByte(final int columnIndex, final byte x) throws SQLException {
		parent.updateByte(columnIndex, x);
	}

	public void updateByte(final String columnName, final byte x) throws SQLException {
		parent.updateByte(columnName, x);
	}

	public void updateBytes(final int columnIndex, final byte[] x) throws SQLException {
		parent.updateBytes(columnIndex, x);
	}

	public void updateBytes(final String columnName, final byte[] x) throws SQLException {
		parent.updateBytes(columnName, x);
	}

	public void updateCharacterStream(final int columnIndex, final Reader x, final int length) throws SQLException {
		parent.updateCharacterStream(columnIndex, x, length);
	}

	public void updateCharacterStream(final String columnName, final Reader reader, final int length) throws SQLException {
		parent.updateCharacterStream(columnName, reader, length);
	}

	public void updateClob(final int columnIndex, final Clob x) throws SQLException {
		parent.updateClob(columnIndex, x);
	}

	public void updateClob(final String columnName, final Clob x) throws SQLException {
		parent.updateClob(columnName, x);
	}

	public void updateDate(final int columnIndex, final Date x) throws SQLException {
		parent.updateDate(columnIndex, x);
	}

	public void updateDate(final String columnName, final Date x) throws SQLException {
		parent.updateDate(columnName, x);
	}

	public void updateDouble(final int columnIndex, final double x) throws SQLException {
		parent.updateDouble(columnIndex, x);
	}

	public void updateDouble(final String columnName, final double x) throws SQLException {
		parent.updateDouble(columnName, x);
	}

	public void updateFloat(final int columnIndex, final float x) throws SQLException {
		parent.updateFloat(columnIndex, x);
	}

	public void updateFloat(final String columnName, final float x) throws SQLException {
		parent.updateFloat(columnName, x);
	}

	public void updateInt(final int columnIndex, final int x) throws SQLException {
		parent.updateInt(columnIndex, x);
	}

	public void updateInt(final String columnName, final int x) throws SQLException {
		parent.updateInt(columnName, x);
	}

	public void updateLong(final int columnIndex, final long x) throws SQLException {
		parent.updateLong(columnIndex, x);
	}

	public void updateLong(final String columnName, final long x) throws SQLException {
		parent.updateLong(columnName, x);
	}

	public void updateNull(final int columnIndex) throws SQLException {
		parent.updateNull(columnIndex);
	}

	public void updateNull(final String columnName) throws SQLException {
		parent.updateNull(columnName);
	}

	public void updateObject(final int columnIndex, final Object x, final int scale) throws SQLException {
		parent.updateObject(columnIndex, x, scale);
	}

	public void updateObject(final int columnIndex, final Object x) throws SQLException {
		parent.updateObject(columnIndex, x);
	}

	public void updateObject(final String columnName, final Object x, final int scale) throws SQLException {
		parent.updateObject(columnName, x, scale);
	}

	public void updateObject(final String columnName, final Object x) throws SQLException {
		parent.updateObject(columnName, x);
	}

	public void updateRef(final int columnIndex, final Ref x) throws SQLException {
		parent.updateRef(columnIndex, x);
	}

	public void updateRef(final String columnName, final Ref x) throws SQLException {
		parent.updateRef(columnName, x);
	}

	public void updateRow() throws SQLException {
		parent.updateRow();
	}

	public void updateShort(final int columnIndex, final short x) throws SQLException {
		parent.updateShort(columnIndex, x);
	}

	public void updateShort(final String columnName, final short x) throws SQLException {
		parent.updateShort(columnName, x);
	}

	public void updateString(final int columnIndex, final String x) throws SQLException {
		parent.updateString(columnIndex, x);
	}

	public void updateString(final String columnName, final String x) throws SQLException {
		parent.updateString(columnName, x);
	}

	public void updateTime(final int columnIndex, final Time x) throws SQLException {
		parent.updateTime(columnIndex, x);
	}

	public void updateTime(final String columnName, final Time x) throws SQLException {
		parent.updateTime(columnName, x);
	}

	public void updateTimestamp(final int columnIndex, final Timestamp x) throws SQLException {
		parent.updateTimestamp(columnIndex, x);
	}

	public void updateTimestamp(final String columnName, final Timestamp x) throws SQLException {
		parent.updateTimestamp(columnName, x);
	}

	public boolean wasNull() throws SQLException {
		return parent.wasNull();
	}
}
