/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.id;

import woolpack.fn.Delegator;
import woolpack.fn.Fn;

/**
 * 委譲先から復帰したときに識別子の値を呼び出し時の状態に初期化する{@link Fn}です。
 * 
 * @author nakamura
 * 
 * @param <C>
 * @param <R>
 * @param <E>
 */
public class LocalId<C extends IdContext, R, E extends Exception> extends Delegator<C, R, E> {

	public LocalId(final Fn<? super C, ? extends R, ? extends E> fn) {
		super(fn);
	}

	public R exec(final C c) throws E {
		final String id = c.getId();
		try {
			return super.exec(c);
		} finally {
			c.setId(id);
		}
	}
}
