/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.w3c.dom.Node;
import org.w3c.dom.Text;

import woolpack.xml.AbstractNodeSeeker;
import woolpack.xml.NodeContext;

/**
 * テキストノードの空白文字を圧縮する{@link woolpack.fn.Fn}です。
 * @author nakamura
 *
 */
public class SpaceCompressor<E extends Exception> extends AbstractNodeSeeker<NodeContext, E> {
	private static final Pattern SPACE_PATTERN = Pattern.compile("[ \\t\\r\\n]{2,}");
	
	@Override
	public Void exec(final NodeContext context) throws E {
		super.exec(context);
		if (context.getNode().getNodeType() == Node.TEXT_NODE) {
			final Text t = (Text) context.getNode();
			final Matcher m = SPACE_PATTERN.matcher(t.getWholeText());
			t.replaceWholeText(m.replaceAll(" "));
		}
		return null;
	}
}
