/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import woolpack.fn.Fn;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/**
 * テーブルに行番号列を追加する{@link Fn}です。
 * @author nakamura
 *
 * @param <E>
 */
public class RowIndexInserter<E extends Exception> implements Fn<NodeContext, Void, E> {
	private String headValue;
	
	public RowIndexInserter(final String headValue) {
		this.headValue = headValue;
	}

	public Void exec(final NodeContext c) {
		final Document d = XmlUtils.getDocumentNode(c.getNode());
		final NodeList trList = HtmlUtils.TR_LIST.exec(c.getNode());
		for (int i = 0; i < trList.getLength(); i++) {
			final Node node = trList.item(i);
			final Element element = d.createElement("TD");
			final String s = (i == 0) ? headValue : String.valueOf(i);
			element.appendChild(d.createTextNode(s));
			node.insertBefore(element, node.getFirstChild());
		}
		return null;
	}

	public String getHeadValue() {
		return headValue;
	}
	public void setHeadValue(final String headValue) {
		this.headValue = headValue;
	}
}
