/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import org.w3c.dom.Node;

import woolpack.xml.AbstractNodeSeeker;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/**
 * SCRIPT ノード以外のコメントノードを削除する{@link woolpack.fn.Fn}です。
 * @author nakamura
 *
 */
public class CommentRemover<E extends Exception> extends AbstractNodeSeeker<NodeContext, E> {
	@Override
	public Void exec(final NodeContext context) throws E {
		super.exec(context);
		if (context.getNode().getNodeType() == Node.COMMENT_NODE) {
			if (!context.getNode().getParentNode().getNodeName().equals("SCRIPT")) {
				XmlUtils.removeThis(context.getNode());
			}
		}
		return null;
	}
}
