/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

/**
 * ドット区切りのプロパティ名の順にたどっていく{@link EL}です。
 * 
 * @author nakamura
 * 
 */
public class PathEL extends AbstractEL {
	private String expression;
	private PropertyELFactory factory;
	private EL el;

	/**
	 * @param expression プロパティ名をドットでつなげた表現。
	 * @param factory 型変換器。
	 */
	public PathEL(final String expression, final PropertyELFactory factory) {
		super();
		this.expression = expression;
		this.factory = factory;
		generate();
	}
	
	private void generate() {
		final StringTokenizer st = new StringTokenizer(expression, ".");
		final Collection<EL> c = new ArrayList<EL>();
		while (st.hasMoreTokens()) {
			c.add(new PropertyEL(st.nextToken(), factory));
		}
		el = new ArrayPathEL(c);
	}

	/**
	 * @param expression プロパティ名をドットでつなげた表現。
	 */
	public PathEL(final String expression) {
		this(expression, ELUtils.PROPERTY_EL_FACTORY);
	}

	@Override
	public Object getValue(final Object root, final Class clazz) {
		return el.getValue(root, clazz);
	}

	@Override
	public void setValue(final Object root, final Object value) {
		el.setValue(root, value);
	}
	
	public String getExpression() {
		return expression;
	}
	public void setExpression(final String expression) {
		this.expression = expression;
		generate();
	}
	public PropertyELFactory getFactory() {
		return factory;
	}
	public void setFactory(final PropertyELFactory factory) {
		this.factory = factory;
		generate();
	}
}
