/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.container;

import woolpack.fn.Fn;

/**
 * ユーティリティです。
 * 型推論で表記を簡略するためのスタティックメソッドと変数を含みます。
 * @author nakamura
 *
 */
public final class ContainerUtils {
	
	private ContainerUtils() {
	}
	
	/**
	 * {@link ContainerContext#getKey()}を返す{@link Fn}を返します。
	 * @param <C>
	 * @return 関数。
	 */
	public static <C extends ContainerContext<?>> Fn<C, Object, RuntimeException> getKey() {
		return new Fn<C, Object, RuntimeException>() {
			public Object exec(final C c) {
				return c.getKey();
			}
		};
	}
	
	/**
	 * {@link ContainerContext#getSubContext()}を返す{@link Fn}を返します。
	 * @param <S>
	 * @param <C>
	 * @return {@link ContainerContext#getSubContext()}を返す{@link Fn}。
	 */
	public static <S, C extends ContainerContext<S>> Fn<C, S, Exception> getSubContext() {
		return new Fn<C, S, Exception>() {
			public S exec(final C c) {
				return c.getSubContext();
			}
		};
	}
}
