/*
 * Decompiled with CFR 0.152.
 */
package woolpack.typeconvert;

import java.lang.reflect.Array;
import java.util.Collection;
import woolpack.fn.Delegator;
import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToArrayConverter
extends Delegator<ConvertContext, Void, RuntimeException> {
    public ToArrayConverter(Fn<ConvertContext, Void, ? extends RuntimeException> fn) {
        super(fn);
    }

    @Override
    public Void exec(ConvertContext c) {
        if (!c.getToType().isArray()) {
            super.exec(c);
            return null;
        }
        Collection collection = Utils.toCollection(c.getValue());
        Class baseToType = c.getToType();
        Object baseValue = c.getValue();
        boolean successFlag = false;
        try {
            Class<?> componentType = baseToType.getComponentType();
            c.setToType(componentType);
            boolean primitiveFlag = componentType.isPrimitive();
            Object afterArray = Array.newInstance(componentType, collection.size());
            int i = 0;
            for (Object before : collection) {
                c.setValue(before);
                c.getFn().exec(c);
                if (!primitiveFlag || c.getValue() != null) {
                    Array.set(afterArray, i, c.getValue());
                }
                ++i;
            }
            successFlag = true;
            c.setValue(afterArray);
        }
        finally {
            c.setToType(baseToType);
            if (!successFlag) {
                c.setValue(baseValue);
            }
        }
        return null;
    }
}

