/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneLineResult<R>
implements Fn<Statement, R, Exception> {
    private Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn;
    private Fn<? super Statement, ? extends R, ? extends Exception> zeroFn;

    public OneLineResult(Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn, Fn<? super Statement, ? extends R, ? extends Exception> zeroFn) {
        this.rowFn = rowFn;
        this.zeroFn = zeroFn;
    }

    public OneLineResult(Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn) {
        this(rowFn, new Fn<Statement, R, SQLException>(){

            @Override
            public R exec(Statement c) throws SQLException {
                throw new SQLException("empty row.");
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R exec(Statement c) throws Exception {
        SQLException e0;
        block9: {
            e0 = null;
            try {
                ResultSet resultSet = c.getResultSet();
                try {
                    if (resultSet.next()) {
                        R r = this.rowFn.exec(resultSet);
                        return r;
                    }
                    R r = this.zeroFn.exec(c);
                    return r;
                }
                catch (SQLException e1) {
                    e0 = e1;
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException e1) {
                if (e0 != null) break block9;
                e0 = e1;
            }
        }
        if (e0 == null) return null;
        throw e0;
    }

    public Fn<? super ResultSet, ? extends R, ? extends Exception> getRowFn() {
        return this.rowFn;
    }

    public void setRowFn(Fn<? super ResultSet, ? extends R, ? extends Exception> fn) {
        this.rowFn = fn;
    }

    public Fn<? super PreparedStatement, ? extends R, ? extends Exception> getZeroFn() {
        return this.zeroFn;
    }

    public void setZeroFn(Fn<? super Statement, ? extends R, ? extends Exception> zeroFn) {
        this.zeroFn = zeroFn;
    }
}

